﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />
</spb:Header>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   User userDomain = Users.GetUser(userDomainName, false);
   int UserApplicationID = ApplicationIDs.Instance().User(); %>
<body class="tn-page-bg" id="spb-company-page">
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper">
                <%  ViewData["ApplicationID"] = UserDomainSpecialAppIDs.Instance().Home();
                    Html.RenderPartial("Controls/Header.ascx", ViewData); %>
            </div>
        </div>
        <div id="tn-content" class="tn-content-bg tn-doc2">
            <div class="tn-wrapper">
                <div class="tn-grid-1-3">
                    <div class="tn-unit tn-first">
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-company-shortcut">
                            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                <% SPBHtmlHelper.Instance().RenderWidgetInUserDomain(Html, "4e5ebc772a09bb65", userDomain); %>
                            </div>
                        </div>
                        <div class="tn-blank10">
                        </div>
                        <% Html.RenderAction<UserDomainController>(c => c.ShowCompanyContactProFile(userDomainName)); %>
                    </div>
                    <div class="tn-unit">
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-company-news">
                            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ListCompanyActivities","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                                    <%=GetResourceString("Action_More")%></a></span>
                                <h3 class="tn-helper-reset">
                                    <%=GetResourceString("Title_ListCompanyActivities",UserApplicationID)%>
                                </h3>
                            </div>
                            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                <%Html.RenderAction<MessageCenterController>(n => n.Control_ListUserActivitiesBlock(userDomainName, 10)); %>
                            </div>
                        </div>
                        <div class="tn-blank10">
                        </div>
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-company-msg-board">
                            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                <h3 class="tn-helper-reset">
                                    <%=GetResourceString("Title_GuestBookBoard",UserApplicationID)%>
                                </h3>
                            </div>
                            <div class="tn-box-content tn-widget-content tn-corner-bottom" id="MyGuestBookBlockDiv">
                                <% Html.RenderAction<MessageCenterController>(n => n.Control_MyGuestBookBlock(userDomainName)); %>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>
</body>
</html>
