﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<CompanyUser>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
          <% ViewData["CompanyProfileMenu"] = CompanyProfileMenu.CompanySetting;
             Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
<spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <% CompanyUser user = ViewData.Model;
     int applicationID = ApplicationIDs.Instance().User();%>
    <% CompanyProfileTypes type = (CompanyProfileTypes)Request.QueryString.GetInt("type", (int)CompanyProfileTypes.CompanySetting); %>

    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-account-info">
       <div class="tn-box-content tn-widget-content tn-corner-all">
            <% if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   if (messageType == StatusMessageType.Success)
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, true));
                   else
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
               }
               TempData["StatusMessageType"] = null;%>
           <form id="EditProfileForm" enctype="multipart/form-data" method="post" action="<%=SPBUrlHelper.Action("UpdateCompanyProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"prevAccountStatus",user.AccountStatus}}) %>">
             <input type="hidden" id="returnUrl" name="returnUrl" value="<%=Request.RawUrl%>" />
             
             <div class="tn-form tn-label-right">
                <% if (!user.IsEmailVerified)
                   {
                       string emailAddress = EmailAddressConfiguration.GetEmailAddress(user.PrivateEmail);%>
                <div class="tn-widget">
                  <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
                  <span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
                    <div class="tn-helper-flowfix">
                    <strong>提示：</strong>
                      <%=string.Format(GetResourceString("Description_Pattern_ActivatingUserByPrivateEmail", applicationID), user.PrivateEmail, "")%>
                      <% if (!string.IsNullOrEmpty(emailAddress))
                         { %>
                       <a href="<%=emailAddress %>" target="_blank" title="<%=GetResourceString("Description_ActivatyNowTitle", applicationID)%>"><%=GetResourceString("Action_ActivatyNow", applicationID)%></a>
                       <%} %>
                        &nbsp;&nbsp; <a href="<%=SiteUrls.Instance().ResendVerificationCode(userDomainName) %>"><%=GetResourceString("Action_ResendVerifyCode",applicationID) %></a>
                    </div>
                  </div>
                </div>
                <div class="tn-blank10"></div>
                <%} %>
          <%--      <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_ShowMembersOrNot",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                  <div class="tn-input-multiple">
                    <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("enableDisplayInMemberList", user.EnableDisplayInMemberList, new RouteValueDictionary { {"Class","radiobutton" }})%>              
                    </div>
                    <span class="tn-text-note"><%=GetResourceString("Description_ListInWholeSite",applicationID)%> </span>
                  </div>--%>
                <div class="tn-form-row">
                 <label class="tn-form-label"><%=GetResourceString("Label_ShowAvatarOrNot",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                 <div class="tn-input-multiple">
                   <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("enableAvatar", user.EnableAvatar, new RouteValueDictionary { {"Class","radiobutton" }})%>
                   <span class="tn-text-note"><%=GetResourceString("Description_ListInPublicShowAvatar",applicationID)%></span>
                 </div>            
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_ShowUserName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <%=user.UserName %> 
                </div>

                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %></label>
                   <a href="<%=SPBUrlHelper.Action("ChangePassword","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                            id="changePasswordButton"><%=GetResourceString("Action_ChangeUserPassword", applicationID)%></a>           
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_UserEamilAddress",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="privateEmail" id="privateEmail" value="<%=user.PrivateEmail %>" title="<%=GetResourceString("Description_PrivateEmail", applicationID)%>" />
                </div>
                <%Dictionary<int, CodeItem> TimeZoneList = ViewData["TimeZone"] as Dictionary<int, CodeItem>;
                  if (TimeZoneList != null)
                  { %>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_ShowAreaRegion",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <select class="tn-dropdownlist" name="TimeZone" id="TimeZone">
                  <%foreach (var timezone in TimeZoneList)
                    {%>
                    <option <%if (timezone.Key == (int)user.Timezone) Response.Write("selected=\"selected\""); %> value="<%=timezone.Key %>" > <%=timezone.Value.GetMultilingualName(CurrentUserLanguage)%></option>
                  <%} %>
                  </select>   
                </div>
                <%} %>
                <%SiteSettings setting = null;
                  if (ViewData["SiteSetting"] != null)
                      setting = ViewData["SiteSetting"] as SiteSettings;
                  Dictionary<string, string> languages = null;
                  if (ViewData["languages"] != null)
                      languages = ViewData["languages"] as Dictionary<string, string>;
                  if (languages != null && setting != null && setting.EnableMultilingual)
                  { %>
                <div class="tn-form-row">
                  <label class="tn-form-label"> <%=GetResourceString("Label_ShowLanguage", applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                  <select class="tn-dropdownlist" name="languages" id="languages">
                  <%foreach (var dislanguages in languages)
                    {%>
                    <option value="<%=dislanguages.Key %>" <%if (dislanguages.Key == user.Language) Response.Write("selected=\"selected\""); %>><%=dislanguages.Value%></option>
                    <%} %>
                  </select>
                </div>
                <%} %>
                <div class="tn-form-row tn-form-row-button">
                  <label class="tn-form-label"> </label>
                  <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_UpdateUserProfile", applicationID), ButtonSizes.Default, null, null)%>
              </div>
              </div>
          </form>
        </div>
    </div>

  <script type="text/javascript">
      $(document).ready(function () {
          $("#EditProfileForm").validate({
              rules: {
                  privateEmail: { required: true, email: true }
              },
              messages: {
                  privateEmail: { required: '<%=GetResourceString("Validate_PrivateEmailRequired",applicationID)%>', email: '<%=GetResourceString("Validate_PrivateEmailStyle", applicationID)%>' }
              }
          });
          $("#postButton").click(function () {
              if (!$("#EditProfileForm").valid()) {
                  return false;
              }
          });
          $('#privateEmail[title]').qtip({
              position: {
                  corner: {
                      target: 'rightMiddle',
                      tooltip: 'leftMiddle'
                  }
              },
              show: "focusin",
              hide: 'focusout',
              style: {
                  name: 'cream',
                  tip: true
              }
          });
      });
  </script>
</asp:content>
