﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<CompanyUser>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
      <% ViewData["CompanyProfileMenu"] = CompanyProfileMenu.CompanyLogo;
    Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <% CompanyUser user = ViewData.Model;
     int applicationID = ApplicationIDs.Instance().User();%>
    <% CompanyProfileTypes type = (CompanyProfileTypes)Request.QueryString.GetInt("type", (int)CompanyProfileTypes.CompanySetting); %>
  <%if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        TempData["StatusMessageType"] = null;
    }%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-upload-avatar">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=GetResourceString("Label_CompanyUserDomainLogo",applicationID)%><%=GetResourceString("Common_Colon") %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <div class="tn-helper-clearfix">
        <div class="spb-upload-wrapper tn-border-gray tn-border-rbl">
          <div class="spb-upload-fieldset tn-border-gray tn-border-top" id="fsUploadProgress">
              <span class="spb-upload-legend"></span>
          </div>
          <div style="display: none;" id="divStatus">
          </div>
             <div class="spb-upload-actions tn-border-gray tn-border-top">
               <%if (TempData["StatusMessageType"] != null)
                 {
                     StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                     if (messageType == StatusMessageType.Success)
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                     else
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
                 }
                 TempData["StatusMessageType"] = null;%>
               <% string handdlerUrl = Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, WebUtils.ResolveUrl("~/Services/CompanyUploadLogo.ashx"));
                  string flashUrl = Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
                  string uploadFileTypes = "*.gif;*.jpg;*.jpeg;*.png;*.bmp;";
                  int maxFileSize = 1024;
                %>
                <% Html.RenderAction<ChannelController>(n => n.Control_UploadAvatarAttachment(userDomainName, handdlerUrl, flashUrl, user.UserID, uploadFileTypes, maxFileSize.ToString(), false, string.Empty)); %>
                </div>
            </div>
            <div class="spb-upload-tips tn-border-gray tn-border-bottom tn-text-note">
               
               推荐上传的头部标识图片的尺寸是480x60，最大容量是512K。
            </div>

         <div class="spb-avatar-box" style="overflow-x:auto;width:100%;">
            <% if (Avatars.GetCompanyLogo(user.UserID) != null)
               { %>
            <img src="<%=SiteUrls.Instance().CompanyLogoUrl(user.UserID,false)%>" title="<%=user.DisplayName %>" alt="" />
            <%} %>
        </div>
      </div>
    </div>
  </div>
</asp:content>
