﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<CompanyUser>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
    <% ViewData["CompanyProfileMenu"] = CompanyProfileMenu.BasicMessage;
    Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <% CompanyUser user = ViewData.Model;
     int applicationID = ApplicationIDs.Instance().User();%>
  <% CompanyProfileTypes type = (CompanyProfileTypes)Request.QueryString.GetInt("type", (int)CompanyProfileTypes.CompanySetting); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-basic-info">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <% if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             if (messageType == StatusMessageType.Success)
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
             else
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
         }
         TempData["StatusMessageType"] = null;%>
      <form id="EditProfileForm" class="tn-helper-reset" enctype="multipart/form-data" method="post" action="<%=SPBUrlHelper.Action("UpdateCompanyProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"prevAccountStatus",user.AccountStatus}}) %>">
        <div class="tn-form-box">
          <%
              IDictionary<int, CodeItem> dicCompanyPropertys = null;
              IDictionary<int, CodeItem> Funds = null;
              IDictionary<int, CodeItem> EmployeeCounts = null;
              IDictionary<int, CodeItem> Trades = null;
              if (ViewData["CompanyPropertys"] != null)
              {
                  dicCompanyPropertys = ViewData["CompanyPropertys"] as Dictionary<int, CodeItem>;
              }
              if (ViewData["Trades"] != null)
              {
                  Trades = ViewData["Trades"] as Dictionary<int, CodeItem>;
              }
              if (ViewData["Funds"] != null)
              {
                  Funds = ViewData["Funds"] as Dictionary<int, CodeItem>;
              }
              if (ViewData["EmployeeCounts"] != null)
              {
                  EmployeeCounts = ViewData["EmployeeCounts"] as Dictionary<int, CodeItem>;
              }
            %>
          <input type="hidden" id="returnUrl" name="returnUrl" value="<%=Request.RawUrl%>" />
          <table>
            <tbody>
              <tr>
                <th><span class="tn-form-required">*</span><%=GetResourceString("Label_CompanyUserName",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-longest tn-border-gray" id="CommonName" name="CommonName" value="<%=user.CommonName %>" maxlength="64" style="width: 300px" />
                  </span></td>
              </tr>
              <tr>
                <th><%=GetResourceString("Label_UserDomainDescription",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-longest tn-border-gray" id="UserDomainDescription" name="UserDomainDescription"
                                    value="<%=user.UserDomainDescription %>" maxlength="100" style="width: 300px" />
                  </span></td>
              </tr>
              <tr>
                <th>显示头部标识：</th>
                <td><span class="tn-form-row">
                  <input type="radio"  class="tn-radiobutton" id="yes" name="IsShowLogo"  onclick="if(!confirm('注意：如果显示企业Logo，则不会显示企业名称与描述！\n你确定要允许吗？')){ return false; }"
                                    value="true" <%if (user.IsShowLogo) Response.Write("checked=\"checked\""); %>  />
                  <label for="yes">是</label>
                  <input type="radio" class="tn-radiobutton" id="no" name="IsShowLogo"
                                    value="false" <%if (!user.IsShowLogo) Response.Write("checked=\"checked\""); %>  />
                  <label for="no">否</label>
                  </span></td>
              </tr>
              <tr>
                <th><span class="tn-form-required">*</span><%=GetResourceString("Label_CompanyUserLicence",applicationID)%><%=GetResourceString("Common_Colon") %> </th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-longest tn-border-gray"  maxlength="100" style="width: 300px" id="Licence" name="Licence" value="<%=user.Licence %>"
                            title="<%=GetResourceString("Description_CompanyUserLicence",applicationID)%>" />
                  </span></td>
              </tr>
              <tr>
                <th><span class="tn-form-required">*</span><%=GetResourceString("Label_CompanyUserTrade",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().ShowDropDownList("Trades", Trades.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, user.Trade)%> </span></td>
              </tr>
              <tr>
                <th><span class="tn-form-required">*</span><%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row">
                  <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", UserDomainConfiguration.Instance().RootAreaCode, user.AreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
                  </span></td>
              </tr>
              <tr>
                <th><%=GetResourceString("Label_CompanyUserProperty",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().ShowDropDownList("CompanyPropertys", dicCompanyPropertys.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, user.CompanyProperty)%> </span></td>
              </tr>
              <tr>
                <th><%=GetResourceString("Label_CompanyUserFund",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().ShowDropDownList("Funds", Funds.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, user.Fund)%> </span></td>
              </tr>
              <tr>
                <th><%=GetResourceString("Label_CompanyUserEmployeeNum",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().ShowDropDownList("EmployeeCounts", EmployeeCounts.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, user.EmployeeNum)%> </span></td>
              </tr>
              <tr>
                <th><%=GetResourceString("Label_CompanyUserIntro",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Standard, "Intro", user.Intro, new RouteValueDictionary { { "style", "width:100%" } })%> </span></td>
              </tr>
              <tr>
                <th><span class="tn-form-required">*</span><%=GetResourceString("Label_CompanyUserLinkman",applicationID)%><%=GetResourceString("Common_Colon") %> </th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="Linkman" name="Linkman" value="<%=user.Linkman %>"
                                    maxlength="64"/>
                  </span></td>
              </tr>
              <tr>
                <th><span class="tn-form-required">*</span><%=GetResourceString("Label_CompanyUserLinkmanDuty",applicationID)%><%=GetResourceString("Common_Colon") %> </th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="LinkmanDuty" name="LinkmanDuty" value="<%=user.LinkmanDuty%>"
                                    maxlength="64" />
                  </span></td>
              </tr>
              <tr>
                <th><%=GetResourceString("Label_CompanyUserLinkTel",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="LinkTel" name="LinkTel" value="<%=user.LinkTel%>"
                       maxlength="64" />
                  </span></td>
              </tr>
              <tr>
                <th><%=GetResourceString("Label_CompanyUserFax",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="Fax" name="Fax" value="<%=user.Fax %>" maxlength="64" />
                  </span></td>
              </tr>
              <tr>
                <th><span class="tn-form-required">*</span><%=GetResourceString("Label_CompanyUserAddress",applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row">
                  <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Address" name="Address" value="<%=user.Address.Trim() %>"
                                    maxlength="128"  />
                  </span></td>
              </tr>
              <tr>
                <th></th>
                <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().SubmitButton("postButton",GetResourceString("Button_UpdateUserBaseInfo",applicationID),ButtonSizes.Default,null,null) %> </span></td>
              </tr>
            </tbody>
          </table>
        </div>
      </form>
    </div>
    <script type="text/javascript">
      
      
          $(document).ready(function() {
          
              $(".tabs").tabs({
              cookie: { expires: 30 },
              selected: <%=(int)type %> ,
              select: function(event, ui) {
                  var url = $.data(ui.tab, 'load.tabs');
                  if (url) {
                      location.href = url;
                      return false;
                  }
                  return true;
              }
              });
              $("#EditProfileForm").validate({
                  rules: {
                      nickName: { required: true, maxBlength: 30 },
                      birthday: { dateISO: true },
                      publicEmail: { email: true },
                      homeFax: { digits: true, minlength: 4, maxlength: 20 },
                      LinkTel: { minBlength: 4, maxBlength: 20 },
                      mobile: { digits: true, minlength: 11, maxlength: 20 },
                      Licence: { required: true, maxBlength: 64 },
                      verifyCode: { required: true },
                      Trades: { required: true, min: 1 },
                      nowArea: { required: true, min: 1 },
                      Linkman: { required: true },
                      CommonName: { required: true },
                      Address: { required: true, maxBlength: 128 },
                      areaCode:{required: true},
                      LinkmanDuty:{required: true,maxBlength:64}
                  },
                  messages: {
                      nickName: { required: '<%=GetResourceString("Validate_NickNameRequired",applicationID)%>', maxBlength: '<%=GetResourceString("Validate_NickNameMaxLength", applicationID)%>' },
                      birthday: { dateISO: '<%=GetResourceString("Validate_BirthdayDateISO", applicationID)%>' },
                      homeFax: { digits: '<%=GetResourceString("Validate_DigitsRequired", applicationID)%>', minlength: '<%=GetResourceString("Validate_HomeFaxMinlength", applicationID)%>', maxlength: '<%=GetResourceString("Validate_HomeFaxMaxlength", applicationID)%>' },
                      publicEmail: { email: '<%=GetResourceString("Validate_PublicEmailStyle", applicationID)%>' },
                      LinkTel: { minBlength: '<%=GetResourceString("Validate_LinkTelMinlength", applicationID)%>', maxlength: '<%=GetResourceString("Validate_LinkTelMaxlength", applicationID)%>' },
                      mobile: { digits: '<%=GetResourceString("Validate_DigitsRequired", applicationID)%>', minlength:'<%=GetResourceString("Validate_MobileMinlength", applicationID)%>', maxlength: '<%=GetResourceString("Validate_MobileMaxlength", applicationID)%>' },
                      Licence: { required: '<%=GetResourceString("Validate_LicenceRequired", applicationID)%>', maxBlength: "营业执照最大长度为64个字" },
                      Trades: { required: '<%=GetResourceString("Validate_TradesRequired", applicationID)%>', min:'<%=GetResourceString("Validate_TradesMin", applicationID)%>' },
                      nowArea: { required: '<%=GetResourceString("Validate_NowAreaRequired", applicationID)%>', min: '<%=GetResourceString("Validate_NowAreaMin", applicationID)%>' },
                      Linkman: { required: '<%=GetResourceString("Validate_LinkmanRequired", applicationID)%>' },
                      CommonName: { required:'<%=GetResourceString("Validate_CommonNameRequired", applicationID)%>' },
                       areaCode:{required: "所在地区不能为空"},
                       LinkmanDuty:{required: "联系人职位不能为空",maxBlength:"联系人职位最长不能超过64个字"},
                      Address: { required: '<%=GetResourceString("Validate_AddressRequired", applicationID)%>', maxBlength: '<%=GetResourceString("Validate_AddressMaxlength", applicationID)%>' }
                  }
              });
              $("#postButton").click(function() {
                  if (!$("#EditProfileForm").valid()) {
                      return false;
                  }
              });
              $('#Licence[title]').qtip({
              position: {
                  corner: {
                      target: 'rightMiddle',
                      tooltip: 'leftMiddle'
                  }
              },
              show: "focusin",
              hide: 'focusout',
              style: {
                  name: 'cream',
                  tip: true
              }
          });
          });
        </script>
  </div>
</asp:content>
