﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<AdvertisingPosition>" %>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();refresh();</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    AdvertisingPosition position = ViewData.Model;
    bool isCreate = ViewData.GetBool("isCreate", true);
%>
<%
    string actionUrl = Globals.GetFullUrlInFileHandlerSite(Advertisings.StorageProviderName, this.Url.Action("CreateUpdateAdvertisingPosition", "Auxiliaries", new { positionCode = position.PositionCode, isCreate = isCreate }));
%>
<form id="editor" action="<%=actionUrl%>" method="post" class="tn-helper-reset nyroModal"
enctype="multipart/form-data">
<div class="tn-form-box">
<div class="tn-text-heading tn-border-gray tn-border-bottom">
              <h4> <%if (string.IsNullOrEmpty(position.PositionCode)) { Response.Write("新建广告位"); } else { Response.Write("编辑广告位"); } %></h4>
            </div>
    <table>
        <tbody>
            <tr>
                <th>
                <span class="tn-form-required">*</span>
                    位置编码：
                </th>
                <td>
                <span class="tn-form-row">
                    <input type="text" id="positionCode" class="tn-textbox tn-input-long tn-border-gray" name="positionCode" style="width: 170px"
                        value="<%=position.PositionCode %>" <%if (!isCreate) { Response.Write("readonly=\"readonly\""); } %> />
                        </span>
                </td>
            </tr>
            <tr>
                <th>
                    <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %>
                </th>
                <td>
                <span class="tn-form-row tn-textarea-wrap">
                    <textarea id="description" class="tn-textarea tn-input-long tn-border-gray" rows="5" cols="27" name="description"><%=position.Description %></textarea>
                    <span style="display:none"></span>
                    </span>
                </td>
            </tr>
            <tr>
                <th>
                </th>
                <td>
                    <%if (!string.IsNullOrEmpty(position.ImageUrl))
                      {%>
                      <span class="tn-form-row">
                    <img src="<%=SiteUrls.Instance().AdvertisingPositionImage(position.PositionCode) %>"
                        height="100px" style="max-width: 200px;" />
                        </span>
                    <%}%>
                </td>
            </tr>
            <tr>
                <th>
                    广告位图示：
                </th>
                <td>
                <span class="tn-form-row">
                    <input type="file" class="" name="imageUrl" />
                    </span>
                </td>
            </tr>
            <tr>
                <th>
                    拥有者类型：
                </th>
                <td>
                <span class="tn-form-row">
                    <select name="PresentAreaID" id="PresentAreaID" class="tn-dropdownlist">
                        <option value="<%=PresentAreaIDs.Instance().Channel() %>" <%if(position.PresentAreaID == PresentAreaIDs.Instance().Channel())Response.Write(" selected=\"selected\""); %>>
                            系统广告</option>
                        <option value="<%=PresentAreaIDs.Instance().UserDomain() %>" <%if(position.PresentAreaID == PresentAreaIDs.Instance().UserDomain())Response.Write(" selected=\"selected\""); %>>
                            用户广告</option>
                        <option value="<%=PresentAreaIDs.Instance().ClubDomain() %>" <%if(position.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())Response.Write(" selected=\"selected\""); %>>
                            群组广告</option>
                    </select>
                    </span>
                </td>
            </tr>
            <tr>
                <th>
                    允许系统投放：
                </th>
                <td>
                <span class="tn-form-row">
                    <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("allowSystem", position.AllowSystem, new RouteValueDictionary { { "Class", "radiobutton" } })%>
                    </span>
                </td>
            </tr>
            <tr>
                <th>
                <span class="tn-form-required">*</span>
                    广告宽度：
                </th>
                <td>
                <span class="tn-form-row">
                    <input type="text" id="width" class="tn-textbox tn-input-long tn-border-gray" name="width" style="width: 170px" value="<%=position.Width %>" />
                    </span>
                </td>
            </tr>
            <tr>
                <th>
                <span class="tn-form-required">*</span>
                    广告高度：
                </th>
                <td>
                <span class="tn-form-row">
                    <input type="text" id="height" class="tn-textbox tn-input-long tn-border-gray" name="height" style="width: 170px"
                        value="<%=position.Height %>" />
                        </span>
                </td>
            </tr>
            <tr>
                <th>
                <span class="tn-form-required">*</span>
                    允许广告数量：
                </th>
                <td>
                <span class="tn-form-row">
                    <input type="text" id="maximum" class="tn-textbox tn-input-long tn-border-gray" name="maximum" style="width: 170px"
                        value="<%=position.Maximum %>" />
                        </span>
                </td>
            </tr>
            <tr>
                <th>
                </th>
                <td>
                    <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Large,null, null)%>
        <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
                </td>
            </tr>
        </tbody>
    </table>
    <input type="hidden" id="currentUserID" name="currentUserID" value="<%=EncryptManager.EncryptTokenForInviteFriend(Globals.GetCurrentUser().UserID.ToString()) %>" />
</div>
</form>

<script type="text/javascript" rel="forceLoad">
    <!--
    $(document).ready(function() {
        $("#editor").validate({
            rules: {
                positionCode: { required: true},
                width: { required: true, digits: true },
                height: { required: true, digits: true },
                maximum: { required: true, digits: true }
            },
            messages: {
                positionCode: { required: "必填" },
                width: { required: "必填", digits: "请输入正整数" },
                height: { required: "必填", digits: "请输入正整数" },
                maximum: { required: "必填", digits: "请输入正整数" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#editor").valid()) {
                return false;
            }
        });
    });

    function closeModal() {
        $.nyroModalRemove(); refresh();
    }
   //--> 
</script>

<%   
    if (TempData["StatusMessageType"] != null)
    {
        if ((StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error) == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\"> debugger;  $.nyroModalRemove();</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    
%>