﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));

        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }

    ConvertibleGift gift = null;
    if (ViewData["gift"] != null)
        gift = ViewData["gift"] as ConvertibleGift;
    string action = Globals.GetFullUrlInFileHandlerSite(ConvertibleGifts.StorageProviderName, SPBUrlHelper.Action("CreateConvertibleGift", "Auxiliaries"));
    if (gift != null)
        action = Globals.GetFullUrlInFileHandlerSite(ConvertibleGifts.StorageProviderName, SPBUrlHelper.Action("UpdateConvertibleGift", "Auxiliaries", new RouteValueDictionary { { "giftID", gift.GiftID } }));
%>

<form action="<%=action%>" method="post" id="editorForm" class="tn-helper-reset nyroModal"
enctype="multipart/form-data">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> 添加/修改礼品信息 </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> 礼品名称： </label>
      <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 200px;" name="Subject" value="<%if(gift!=null) Response.Write(gift.Subject); %>" />
      <span class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label tn-textarea-wrap"> 礼品描述： </label>
      <textarea class="tn-textarea tn-input-long tn-border-gray" rows="4" cols="30" name="body">
      <%if (gift != null) Response.Write(Formatter.FormatMultiLinePlainTextForEdit(gift.Body, true)); %>
      </textarea>
      <span class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 礼品标识图： </label>
      <%
            if (gift != null && !string.IsNullOrEmpty(gift.ImageFileName))
            {
                Response.Write(string.Format("<img src=\"{0}\" width=\"110\" height=\"100\" />", SiteUrls.Instance().GiftPhoto(gift)));
            }
        %>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> </label>
      <input type="file" class="fileUpload" name="picfile" id="picfile" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> </label>
      <span class="tn-text-note">支持jpeg、gif。最佳尺寸为110*50</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 兑换<%=GetResourceString("Label_TradePoint", ApplicationIDs.Instance().User())%>： </label>
      <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 200px;" name="price" value="<% if (gift != null) Response.Write(gift.Price); %>" />
      <span class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 礼品数量： </label>
      <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 200px;" name="totalCount" value="<% if (gift != null) Response.Write(gift.TotalCount); %>" />
      <span class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 排序序号： </label>
      <input type="text" maxlength="20" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 200px;" style="width: 100px;" value="<% if (gift != null) Response.Write(gift.DisplayOrder); else Response.Write("0");%>"
            name="displayorder" />
      <span class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 是否启用： </label>
      <input type="checkbox" name="isenable" id="isenable" value="true" <%if (gift != null && gift.IsEnabled) Response.Write(" checked=\"checked\"");%>
            <% if (gift == null) Response.Write(" checked=\"checked\"");%> />
      <label for="isenable"> 启用</label>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <input id="editorFormsaveButton" type="submit" value="提交" />
      &nbsp;
      <input type="button" onclick="$.nyroModalRemove();" value="取消" />
    </div>
  </div>
</form>
<script type="text/javascript" rel="forceLoad">

    $(document).ready(function() {
        $("#editorForm").validate({
            rules: {
                Subject: { required: true, maxBlength: 100 },
                body: { required: true },
                price: { required: true, digits: true },
                <%if(gift==null || gift.GiftID<=0){ %>
                 picfile:{required: true},
                <%} %>

                displayorder: { required: true, digits: true },
                totalCount: { required: true, digits: true }
            },
            messages: {
                Subject: { required: "请输入标题", maxBlength: "最大长度不能超过100字" },
                body: { required: "请输入描述" },
                price: { required: "请输入兑换所需<%=GetResourceString("Label_TradePoint", ApplicationIDs.Instance().User())%>", digits: "请输入非负整数" },
            <%if(gift==null || gift.GiftID<=0){ %>
               picfile: { required: "请选择图片" },
            <%} %>
             
                displayorder: { required: "请输入排序序号", digits: "请输入非负整数" },
                totalCount: { required: "请输入礼品数量", digits: "请输入非负整数" }
            }
        });

        $("#editorFormsaveButton").click(function() {
            if (!$("#editorForm").valid()) {
                return false;
            }
        });
    }); 
</script>
