﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }


    Link SiteLink = null;
    if (ViewData["SiteLink"] != null)
        SiteLink = ViewData["SiteLink"] as Link;

    List<LinkCategory> listlinkCate = null;
    if (ViewData["LinkCategories"] != null)
        listlinkCate = ViewData["LinkCategories"] as List<LinkCategory>;
    string action = string.Empty;
    if (SiteLink != null)
        action = Globals.GetFullUrlInFileHandlerSite(LinkManager.StorageProviderName, Url.Action("Control_EditLinkAction", "Auxiliaries", new { linkID = SiteLink.LinkID }));
    else
        action = Globals.GetFullUrlInFileHandlerSite(LinkManager.StorageProviderName, Url.Action("Control_AddLinkAction", "Auxiliaries"));

%>

<form action="<%=action%>" method="post" id="editor" class="tn-helper-reset nyroModal"
enctype="multipart/form-data">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> 添加/修改友情链接 </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> 链接标题： </label>
      <input type="text" value="<% if (SiteLink != null) Response.Write(SiteLink.Title); %>"
            maxlength="100" class="tn-textbox tn-input-long tn-border-gray" name="Title"
            id="Title" />
      <span class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 链接URL： </label>
      <input type="text" value="<% if (SiteLink != null) Response.Write(SiteLink.LinkHref); else Response.Write("Http://");%>"
            maxlength="100" class="tn-textbox tn-input-long tn-border-gray" name="linkUrl" />
      <span
                class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 排序序号： </label>
      <input type="text" maxlength="20" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 100px;" value="<% if (SiteLink != null) Response.Write(SiteLink.DisplayOrder); else Response.Write("0");%>"
            name="displayorder" />
      <span class="tn-form-required">(必填)</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 链接提示： </label>
      <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray"
            name="linkTitle" value="<% if (SiteLink != null) Response.Write(SiteLink.LinkTitle);%>" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 链接类别： </label>
      <select class="tn-dropdownlist" style="width: 75px;" name="linkcate">
        <%
                if (listlinkCate != null)
                    foreach (var item in listlinkCate)
                    {
            %>
        <option value="<%=item.CategoryID %>" <% if (SiteLink != null && item.CategoryID==SiteLink.CategoryID) Response.Write("selected");%>> <%=item.CategoryName %></option>
        <%
                }
            %>
      </select>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 链接种类： </label>
      <span class="radiobutton">
      <%
                if (SiteLink != null)
                {
                    if (SiteLink.LinkType == LinkTypes.Image)
                        Response.Write("<script>$('#linkPicTr').css('display','');</script>");
            %>
      <input name="SiteLinkTypes" type="radio" id="LinkTypes1" value="<%=(int)LinkTypes.Text %>"
                <%  if(SiteLink.LinkType==LinkTypes.Text) Response.Write("checked=\"checked\""); %>
                onclick="$('#linkPicTr').css('display','none')" />
      <label for="LinkTypes1" onclick="$('#linkPicTr').css('display','none')">文字链接</label>
      <input onclick="$('#linkPicTr').css('display','')" type="radio" name="SiteLinkTypes"
                <%  if(SiteLink.LinkType==LinkTypes.Image) Response.Write("checked=\"checked\""); %>
                id="LinkTypes2" value="<%=(int)LinkTypes.Image %>" />
      <label for="LinkTypes2" onclick="$('#linkPicTr').css('display','')">图像链接</label>
      </span>
      <%
            }
                else
                {
        %>
      <input name="SiteLinkTypes" type="radio" id="LinkTypes1" value="<%=(int)LinkTypes.Text %>"
            checked="checked" onclick="$('#linkPicTr').css('display','none')" />
      <label for="LinkTypes1"
                onclick="$('#linkPicTr').css('display','none')">文字链接</label>
      <input onclick="$('#linkPicTr').css('display','')" type="radio" name="SiteLinkTypes"
            id="LinkTypes2" value="<%=(int)LinkTypes.Image %>" />
      <label for="LinkTypes2" onclick="$('#linkPicTr').css('display','')">图像链接</label>
      </span>
      <%} %>
    </div>
    <div id="linkPicTr" style="display: none" class="tn-form-row">
      <label class="tn-form-label"> 链接图片： </label>
      <%
            if (SiteLink != null && SiteLink.LinkType == LinkTypes.Image)
            {
                if (!string.IsNullOrEmpty(SiteLink.ImageUrl))
                    Response.Write(string.Format("<img src=\"{0}\" width=\"110\" height=\"100\" />", SiteUrls.Instance().LinkPhoto(SiteLink, LinkPosition.Site)));
            }
        %>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> </label>
      <input type="file" class="fileUpload" name="picfile" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> </label>
      <span class="tn-text-note">支持jpeg、gif。最佳尺寸为110*50</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 状态： </label>
      <input type="checkbox" name="isenable" id="isenable" value="true" <% if (SiteLink != null && SiteLink.IsEnabled) Response.Write(" checked=\"checked\"");%>
            <% if (SiteLink == null) Response.Write(" checked=\"checked\"");%> />
      <label for="isenable">启用</label>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <input id="saveButton" type="submit" value="<%=GetResourceString("Button_Submit")%>" />
      &nbsp;
      <input type="button" onclick="$.nyroModalRemove();" value="<%=GetResourceString("Button_Cancel")%>" />
    </div>
  </div>
  <input type="hidden" id="currentUserID" name="currentUserID" value="<%=EncryptManager.EncryptTokenForInviteFriend(Globals.GetCurrentUser().UserID.ToString()) %>" />
</form>
<script type="text/javascript" rel="forceLoad">
    <!--
    $(document).ready(function() {
        $("#editor").validate({
            rules: {
                Title: { required: true, maxBlength: 50 },
                linkUrl: { url: true, required: true, maxlength: 100 },
                displayorder: { required: true, digits: true }
            },
            messages: {
                Title: { required: "请输入标题", maxBlength: "最大长度不能超过50字" },
                linkUrl: { url: "请输入合法网址", required: "请输入链接地址", maxlength: "不能超过100个字符" },
                displayorder: { required: "请输入排序序号", digits: "请输入非负整数" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#editor").valid()) {
                return false;
            }
        });
    }); 
   //--> 
</script>
