﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    LinkCategory LinkCate = null;
    if (ViewData["LinkCate"] != null)
        LinkCate = ViewData["LinkCate"] as LinkCategory;
    string action = Url.Action("Control_AddLinkCategoryAction", "Auxiliaries");
    if (LinkCate != null)
        action = Url.Action("Control_EditLinkCategoryAction", "Auxiliaries", new { CateID = LinkCate.CategoryID });
        
%>

<form id="editor" action="<%=action%>" method="post" class="nyroModal">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> 添加/修改友情链接类别 </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> 类别名称： </label>
      <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="category"
            value="<% if (LinkCate != null) { Response.Write(LinkCate.CategoryName); } %>" />
      <span
                class="tn-form-required">(必填) </span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 排序序号： </label>
      <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="displayorder"
            value="<% if (LinkCate != null) { Response.Write(LinkCate.DisplayOrder); } else{ Response.Write("0"); }%>" />
      <span
                class="tn-form-required">(必填) </span> </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %> </label>
      <textarea rows="3" cols="20" class="tn-textarea tn-input-long tn-border-gray"
            name="decript"><% if (LinkCate != null) { Response.Write(LinkCate.Description); } %>
        </textarea>
    <span style="display:none"></span>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <input id="saveButton" type="submit" value="<%=GetResourceString("Button_Submit")%>" />
      &nbsp;
      <input type="button" onclick="$.nyroModalRemove();" value="<%=GetResourceString("Button_Cancel")%>" />
    </div>
  </div>
</form>
<script type="text/javascript" rel="forceLoad">
    <!--
    $(document).ready(function() {
        $("#editor").validate({
            rules: {
                category: { required: true, maxBlength: 50 },
                displayorder: { required: true, digits: true },
                decript: { maxBlength: 50 }
            },
            messages: {
                category: { required: "请输入类别名称", maxBlength: "最大长度不能超过50字" },
                displayorder: { required: "请输入排序序号", digits: "请输入非负整数" },
                decript: { maxBlength: "最大长度不能超过50字" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#editor").valid()) {
                return false;
            }
        });
    }); 
   //--> 
</script>
