﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<RecommendationType>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    RecommendationType type = ViewData.Model;
    Dictionary<int, Application> applications = ViewData["Applications"] as Dictionary<int, Application>;
    int applicationID = -1;
    if (type.TypeID > 0)
        applicationID = type.ApplicationID;
    Dictionary<string, Language> languages = Languages.GetLanguages(false);
%>

<form class="nyroModal" id="EditRecommendationTypeForm" method="post"
action="<%=Url.Action("UpdateRecommendationType", "Auxiliaries",new { recommendTypeID= ViewData.GetInt("TypeID", -1) })%>">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> 添加修改信息类别 </h4>
    <div class="tn-text-note"> 请填写或修改以下信息</div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 类别ID： </label>
      <% if (type.TypeID > 0)
           { Response.Write(type.TypeID); }
           else
           { %>
      <input type="text" id="typeID" name="typeID" class="tn-textbox tn-input-long tn-border-gray" />
      <span class="tn-form-required">必填，设置后不可更改</span>
      <%} %>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 类别名称： </label>
      <input type="text" id="typeName" name="typeName" class="tn-textbox tn-input-long tn-border-gray"
            value="<%=type.Name %>" />
      <span class="tn-form-required">*</span> </div>
    <%foreach (Language language in languages.Values)
      { %>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=language.NativeName%>名称： </label>
      <input type="text" name="RecommendationType_<%=language.LanguageCode %>" class="tn-textbox tn-input-long tn-border-gray"
            value="<%if (Model.RecommendationTypeRes!= null && Model.RecommendationTypeRes.ContainsKey(language.LanguageCode)) { Response.Write(Model.RecommendationTypeRes[language.LanguageCode]); } %>" />
    </div>
    <%} %>
    <div class="tn-form-row">
      <label class="tn-form-label"> 应用对象： </label>
      <select id="applicationID" name="applicationID" class="tn-dropdownlist">
        <option value="-1">请选择</option>
        <% foreach (KeyValuePair<int, Application> pair in applications)
               {%>
        <option value="<%=pair.Key %>"> <%=pair.Value.GetMultilingualApplicationName(CurrentUserLanguage)%></option>
        <%= type.ApplicationID %>
        <%} %>
        <option value="9999">未设置</option>
      </select>
    </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> 类别描述： </label>
      <textarea name="description" id="description" cols="45" rows="3" class="tn-textarea tn-input-long tn-border-gray"><%=type.Description %></textarea>
      <span style="display:none"></span>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <input type="submit" id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
      <input type="reset" class="nyroModalClose" id="cancelButton" value="<%=GetResourceString("Button_Cancel") %>" />
    </div>
  </div>
</form>
<script type="text/javascript">
    $(document).ready(function() {
        $("#applicationID").val("<%=applicationID %>");
        $("#EditRecommendationTypeForm").validate({
            rules: {
                typeID: { required: true, digits: true, min: 1 },
                typeName: { required: true, maxBlength: 10 },
                applicationID: { min: 0 },
                description: { maxBlength: 30 }

            },
            messages: {
                typeID: { required: "请填写类别ID", digits: "类别ID必须是大于或等于0的整数", min: "类别ID必须是大于或等于0的整数" },
                typeName: { required: "请填写类别名称", maxBlength: "类别名称的长度不能超过10个字" },
                applicationID: { min: "请选择应用对象" },
                description: { maxBlength: "类别描述的长度不能超过30个字" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#EditRecommendationTypeForm").valid()) {
                return false;
            }
        });
    });
</script>
