﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<AdvertisingPosition>>" %>
<%--<div class="description"> 投放的广告区域</div>--%>
<% int currentWidth = ViewData.GetInt("currentWidth", 0);
   List<AdvertisingPosition> selectedPosition = ViewData.Get<List<AdvertisingPosition>>("selectedPosition", new List<AdvertisingPosition>());
   int applicationID = ApplicationIDs.Instance().User();
%>
<div id="adpDiv" class="tn-collapsible tn-collapsible-opened">
    <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
        <h4 class="tn-helper-reset">
            <a href="javascript:;;">
                <%=GetResourceString("Title_AdvancedSettings")%></a>
        </h4>
    </div>
    <div class="tn-blank10">
    </div>
    <div class="tn-collapsible-content" style="display: block;">
        <div class="toolbar clearfix">
            <ul>
                <li class="toolbarItem attribute">
                    <%=GetResourceString("Description_SetAdvertisingRegionWidth",applicationID)%><%=GetResourceString("Common_Colon") %>
                    <select class="dropDownList" onchange="$('#apforjueryload').load('<%=this.Url.Action("Control_ListAdvertisingPositions", "Auxiliaries", new { advertisingID = Html.GetParameterFromRouteDateOrQueryString("advertisingID",0) })%>',{width:$(this).val()});">
                        <option value="0">
                            <%=GetResourceString("Enum_AccountStatuses_All")%></option>
                        <%foreach (var width in ViewData.Get<List<int>>("widthList", null))
                          {%>
                        <option <%if(width==currentWidth)Response.Write("selected=\"selected\""); %> value="<%=width %>">
                            <%=width%></option>
                        <%}%>
                    </select>
                </li>
            </ul>
        </div>
        <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <span class="tn-checkbox">
                        <input type="checkbox" onclick="checkAll(this,'positionCheckBoxGroup')" />
                    </span>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_AdvertisingAreaCode",applicationID)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_Description")%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_AdvertisingPreView",applicationID)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_AdvertisingSize",applicationID)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    已经使用/最大数量
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    拥有者类型
                </td>
            </tr>
            <%foreach (var position in ViewData.Model)
              {
                  if (position.Width != currentWidth && currentWidth > 0)
                      continue;%>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <%if (!selectedPosition.Contains(position) && position.UseredAdvertisings >= position.Maximum && position.PresentAreaID == PresentAreaIDs.Instance().Channel())
                      {
                          Response.Write("已满");
                      }
                      else
                      {%>
                    <input type="checkbox" name="positionCheckBoxGroup" value="<%=position.PositionCode %>"
                        class="tn-checkbox" <%if (selectedPosition != null)
                      {
                         if(selectedPosition.Contains(position)){Response.Write(" checked=\"checked\" ");}
                      } %> />
                    <%} %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=position.PositionCode %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%=StringUtils.Trim(position.Description,20) %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%if (!string.IsNullOrEmpty(position.ImageUrl))
                      {%>
                    <a target="_blank" type="formData" href="<%=SiteUrls.Instance().AdvertisingPositionImage(position.PositionCode) %>" class="imageForModal" title="<%=StringUtils.Trim(position.Description,30) %>">
                        查看图示</a>
                    <%}%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%Response.Write(string.Format("{0}*{1}", position.Width, position.Height)); %>
                </td>
                <%if (position.PresentAreaID == PresentAreaIDs.Instance().Channel())
                  { %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%Response.Write(string.Format("{0}/{1}", position.UseredAdvertisings, position.Maximum));%>
                </td>
                <%}
                  else
                  { %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    无限制
                </td>
                <%} %>
                <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                    <%
                        if (position.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                            Response.Write("群组广告");
                        else if (position.PresentAreaID == PresentAreaIDs.Instance().Channel())
                            Response.Write("系统广告");
                        else if (position.PresentAreaID == PresentAreaIDs.Instance().UserDomain())
                            Response.Write("用户广告"); %>
                </td>
            </tr>
            <%}%>
        </table>
    </div>
</div>

<script type="text/javascript">

    $(document).ready(function() {
        $('.imageForModal').nyroModal({
            resizeable: true
        });
        $("#adpDiv.tn-collapsible").collapsibleBox();
    });

</script>

