﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ImpeachReport>>" %>
<%bool? sortBy = null;
  if (ViewData["sortBy"] != null)
  {
      sortBy = ViewData.GetBool("sortBy", false);
  }
  int returnToPageIndex = Request.QueryString.GetInt("pageIndex", 1);
  if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1)
  {
      returnToPageIndex = ViewData.Model.PageIndex - 1;
  }
%>
<div id="impeachDiv" class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <input type="hidden" id="impeachReportOrderBy" name="impeachReportOrderBy" value="<%=sortBy %>" />
        <%--<li class="tn-widget-content tn-border-gray tn-border-trl <% if(ViewData["sortBy"] == null) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=SPBUrlHelper.Action("ManageImpeaches", "Auxiliaries")%>" target="_self">
                <span>
                    <%=GetResourceString("Enum_AccountStatuses_All")%>举报</span></a></li>--%>
        <li class="tn-widget-content tn-border-gray tn-border-trl  <% if(!ViewData.GetBool("sortBy", false)) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=SPBUrlHelper.Action("ManageImpeaches", "Auxiliaries", new RouteValueDictionary { { "sortBy",false} })%>">
                <span>未处理</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(ViewData.GetBool("sortBy", false)) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=SPBUrlHelper.Action("ManageImpeaches", "Auxiliaries", new RouteValueDictionary { { "sortBy",true} })%>">
                <span>已处理</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <div class="tn-list-header">
            <div class="tn-toolbar-area tn-helper-clearfix">
                <%=SPBHtmlHelper.Instance().LinkButton("ImpeachReportAready", "标记为已处理", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary { { "title", "将所有选中的举报信息标记为已处理" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("ImpeachReportNoAready", "标记为未处理", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "将所有选中的举报信息标记为未处理" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("DeleteImpeachReports", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "删除所有选中的举报信息" } }, null)%>
            </div>
        </div>
        <form id="impeachForm" method="post">
        <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom">
                    <input type="checkbox" onclick="checkAll(this,'impeachReportCheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    举报人
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    举报原因
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    举报地址
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    附加说明
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    是否已处理
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_PostDate")%>
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    操作
                </th>
            </tr>
            <% foreach (ImpeachReport impeachReport in ViewData.Model.Records)
               {%>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" name="impeachReportCheckBoxGroup" value="<%=impeachReport.ReportID%>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                    <%if (string.IsNullOrEmpty(impeachReport.Email))
                      {%>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(impeachReport.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                        <%=impeachReport.Author%></a>
                    <% }
                      else
                      {%>
                    <a>
                        <%=impeachReport.Email %></a>
                    <%}%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                    <% 
                        switch ((ImpeachReason)impeachReport.Reason)
                        {
                            case ImpeachReason.Other:
                                Response.Write("其他");
                                break;
                            case ImpeachReason.Reactionary:
                                Response.Write("内容反动");
                                break;
                            case ImpeachReason.Sexy:
                                Response.Write("内容色情");
                                break;
                            case ImpeachReason.Spam:
                                Response.Write("垃圾广告");
                                break;
                            case ImpeachReason.Tortious:
                                Response.Write("内容侵权");
                                break;
                            default:
                                Response.Write("其他");
                                break;
                        }
                    %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <a target="_blank" href="<%=impeachReport.OriginalUrl %>">
                        <%=StringUtils.Trim(impeachReport.OriginalUrl,20) %></a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <a title="<%=impeachReport.Remark %>" class="Model" href="<%=this.Url.Action("Control_ShowImpeach", "Auxiliaries", new {originalUrl = impeachReport.OriginalUrl, remark = impeachReport.Remark })%>">
                        <%=StringUtils.Trim(impeachReport.Remark, 27)%></a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%if (impeachReport.IsComplete)
                      {%>
                    <a href="javascript:;" onclick="$('#impeachDiv').load('<%=this.Url.Action("UpdateImpeachReportStatus","Auxiliaries",new { reportID=impeachReport.ReportID,newCompletedStatus=false,pageIndex=returnToPageIndex}) %>',{sortBy:$('#impeachReportOrderBy').val()})">
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Accept) %>
                    </a>
                    <%}
                      else
                      {%>
                    <a href="javascript:;" onclick="$('#impeachDiv').load('<%=this.Url.Action("UpdateImpeachReportStatus","Auxiliaries",new { reportID=impeachReport.ReportID,newCompletedStatus=true,pageIndex=returnToPageIndex}) %>',{sortBy:$('#impeachReportOrderBy').val()})">
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Cross) %>
                    </a>
                    <%}%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%=Formatter.FormatDate(impeachReport.DateCreated)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%if (impeachReport.IsComplete)
                      {%>
                    <a href="javascript:;" onclick="$('#impeachDiv').parent().load('<%=this.Url.Action("UpdateImpeachReportStatus","Auxiliaries",new { reportID=impeachReport.ReportID,newCompletedStatus=false,pageIndex=returnToPageIndex}) %>',{sortBy:$('#impeachReportOrderBy').val()})">
                        标记为未处理</a>
                    <%}
                      else
                      {%>
                    <a href="javascript:;" onclick="$('#impeachDiv').parent().load('<%=this.Url.Action("UpdateImpeachReportStatus","Auxiliaries",new { reportID=impeachReport.ReportID,newCompletedStatus=true,pageIndex=returnToPageIndex}) %>',{sortBy:$('#impeachReportOrderBy').val()})">
                        标记为已处理</a>
                    <%}%>
                    <a href="javascript:;" onclick="if (confirm('确定要删除该举报信息吗？')) { $('#impeachDiv').parent().load('<%=this.Url.Action("DeleteImpeachReport","Auxiliaries",new { reportID=impeachReport.ReportID,pageIndex=returnToPageIndex}) %>',{sortBy:$('#impeachReportOrderBy').val()})}">
                        删除</a>
                </td>
            </tr>
            <%}
            %>
        </table>
       
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListImpeach", "Auxiliaries", new RouteValueDictionary { { "pageIndex", "{0}" },{ "sortBy",sortBy} }), "pageIndexChange")%>
        </div>
 
        </form>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('.Model').nyroModal({
            resizeable: true
        });

        $("#ImpeachReportAready").click(function () {
            if (confirm('是否将所有选中的举报信息标记为已处理？'))
                $('#impeachForm')
          .ajaxSubmit({ target: '#impeachDiv', url: '<%=this.Url.Action("UpdateImpeachReportStatuses","Auxiliaries",new {newCompletedStatus=true,pageIndex=returnToPageIndex}) %>' })
        });
        $("#ImpeachReportNoAready").click(function () {
            if (confirm('是否将所有选中的举报信息标记为已处理？'))
                $('#impeachForm')
          .ajaxSubmit({ target: '#impeachDiv', url: '<%=this.Url.Action("UpdateImpeachReportStatuses","Auxiliaries",new {newCompletedStatus=false,pageIndex=returnToPageIndex}) %>' })
        });
        $("#DeleteImpeachReports").click(function () {
            if (confirm('是否删除选中的举报信息？'))
                $('#impeachForm')
          .ajaxSubmit({ target: '#impeachDiv', url: '<%=this.Url.Action("DeleteImpeachReports","Auxiliaries",new {pageIndex=returnToPageIndex}) %>' })
        });

    })
    function pageIndexChange(url) {
        $('#impeachDiv').load(url);
    }

</script>
