﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ConvertibleGift>>" %>

<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<div id="ListConvertibleGifts">
  <table class="tn-table-grid">
    <tr class="tn-table-grid-header">
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 礼品名称 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 所需<%=GetResourceString("Label_TradePoint", ApplicationIDs.Instance().User())%> </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 已兑换数 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 剩余个数 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 礼品状态 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
    </tr>
    <%if (ViewData.Model != null)
          {
              if (ViewData.Model.TotalRecords > 0)
              {
                  foreach (ConvertibleGift gift in ViewData.Model.Records)
                  {%>
    <tr class="tn-table-grid-row">
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><h5> <a target="_blank" href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}})%>"> <%=gift.Subject%></a></h5></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=gift.Price%></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=gift.ExchangedCount%></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=gift.TotalCount%></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (gift.IsEnabled)
                  {%>
        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Accept,"上架") %>
        <%}
                  else
                  {%>
        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Accept, "下架")%>
        <%}%></td>
      <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap"><span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                    menu="#moreOptions3<%=gift.GiftID %>"><span class="tn-icon tn-icon-triangle-down"> </span><a name="updateButton" href="<%=SPBUrlHelper.Action("Control_EditConvertibleGift", "Auxiliaries",new RouteValueDictionary {{"giftID",gift.GiftID}})%>"
                        class="tn-action-text nyroModal">编辑</a></span>
        <div id="moreOptions3<%=gift.GiftID %>" class="tn-drop-menu ui-widget-content" style="display: none;">
          <ul class="tn-menu-drop-list">
            <li class="tn-menu-drop-item"><a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Unspecified(),ViewData.GetInt("CurrentUserID", 1),gift.GiftID,gift.Subject)%>"
                            name="ConvertibleGiftsCommend" class="nyroModal">推荐</a></li>
            <li class="tn-menu-drop-item"><a href="<%=SPBUrlHelper.Action("DeleteConvertibleGift", "Auxiliaries", new RouteValueDictionary {{"giftID",gift.GiftID}})%>"
                            onclick="if(!confirm('确定要删除该礼品吗？')) {return false;}">删除</a></li>
            <li class="tn-menu-drop-item"><a name="addSection" id="isEnabled" href="<%=SPBUrlHelper.Action("UpdateGiftIsEnabledStatus", "Auxiliaries", new RouteValueDictionary {{"giftID",gift.GiftID},{"isEnabled",!gift.IsEnabled}})%>">
              <%if (gift.IsEnabled) Response.Write("下架"); else Response.Write("上架"); %>
              </a></li>
          </ul>
        </div></td>
    </tr>
    <%
            }
              }
          }
        %>
  </table>
  <div class="tn-pagination tn-helper-align-center">
    <%
            Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, null));
        %>
  </div>
</div>
<script type="text/javascript">

    $(document).ready(function() {
        $('a.nyroModal').nyroModal({
            resizeable: true,
            width: 500,
            height: 500,
            endRemove: function(elts, settings) {
                $('#ListConvertibleGifts').parent().load('<%=SPBUrlHelper.Action("Control_ManageConvertibleGifts","Auxiliaries")%>');
            }
        });
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
    });

</script>
