﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<PagingDataSet<ConvertibleGiftExchangeApply>>" %>
<div id="ManageFileListsDiv">
    <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom">
             
                    <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
               
            </th>
         <th class="tn-border-gray tn-border-bottom tn-text-note">
                礼品名称
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                收货人
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                购买数量
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                所需积分
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                申请状态
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                操作
            </th>
        </tr>
        <%
            foreach (ConvertibleGiftExchangeApply thread in ViewData.Model.Records)
            {
                if (thread.GiftID > 0)
                {
                    ConvertibleGift gift = ConvertibleGifts.GetGift(thread.GiftID, false);
                    if (gift != null)
                    {
        %>
        <tr class="tn-table-grid-row">
           <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox" value="<%=thread.ApplyID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <a title="<%=gift.Subject %>" href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",thread.GiftID}})%>"
                    target="_blank">
                    <%=gift.Subject%></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=thread.Consignee%><a class="nyroModal" href="<%=SPBUrlHelper.Action("ShowConsigneeInfo","Auxiliaries",new RouteValueDictionary{{"applyID",thread.ApplyID}}) %>">
                  <%=SPBHtmlHelper.Instance().Icon( IconTypes.Jump, "查看申请人信息",new RouteValueDictionary{{"class","tn-icon-inline"}})%>
                 </a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=thread.TotalCount%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=thread.Price%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <% switch (thread.ApplyStatus)
                   {
                       case ConvertibleGiftExchangeApplyStatuses.Accept:
                           Response.Write("已通过");
                           break;
                       case ConvertibleGiftExchangeApplyStatuses.Unsettled:
                           Response.Write("待处理");
                           break;
                       case ConvertibleGiftExchangeApplyStatuses.Refuse:
                           Response.Write("未通过");
                           break;
                       case ConvertibleGiftExchangeApplyStatuses.Canceled:
                           Response.Write("已取消");
                           break;
                       default:
                           break;
                   }  %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">   
             <%if (thread.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Unsettled)
               { %>          
              <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"  menu="#moreOptions3<%=thread.ApplyID %>"> <span class="tn-icon tn-icon-triangle-down"></span> <a  class="tn-action-text" onclick="if ( !confirm('确定要删除这条申请吗？') ) {return false; }" href="<%=SPBUrlHelper.Action("DeleteGiftApply", "Auxiliaries", new RouteValueDictionary {{"applyID",thread.ApplyID}, { "applyStause",thread.ApplyStatus }, { "pageIndex",ViewData.Model.PageIndex }})%>"
                   >删除</a></span>
              <div id="moreOptions3<%=thread.ApplyID %>" class="tn-drop-menu ui-widget-content" style="display:none;">
                <ul class="tn-menu-drop-list">                
               <li class="tn-menu-drop-item"> <a href="<%=SPBUrlHelper.Action("UpdateGiftApplyStaus", "Auxiliaries", new RouteValueDictionary {{"applyID",thread.ApplyID}, { "applyStause", ConvertibleGiftExchangeApplyStatuses.Accept }, { "pageIndex",ViewData.Model.PageIndex }})%>"
                    name="fileManagerCommend">通过</a></li>
               <li class="tn-menu-drop-item"> <a href="<%=SPBUrlHelper.Action("UpdateGiftApplyStaus", "Auxiliaries", new RouteValueDictionary {{"applyID",thread.ApplyID}, { "applyStause", ConvertibleGiftExchangeApplyStatuses.Refuse }, { "pageIndex",ViewData.Model.PageIndex }})%>"
                        target="_self">不通过</a></li>                             
                </ul>
              </div>
                <%}
               else
               { %>   
               <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl" >  <a class="tn-action-text" onclick="if ( !confirm('确定要删除这条申请吗？') ) {return false; }" href="<%=SPBUrlHelper.Action("DeleteGiftApply", "Auxiliaries", new RouteValueDictionary {{"applyID",thread.ApplyID}, { "applyStause",thread.ApplyStatus }, { "pageIndex",ViewData.Model.PageIndex }})%>"
                   >删除</a></span>
              
               <%} %>
                    
            </td>
        </tr>
        <%}
                }
            }%>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%
            Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, null));
            // Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgFilelists.TotalRecords, PgFilelists.PageSize, PgFilelists.PageIndex, 11, Url.Action("ListManageFiles", "ManageFile", new { status = (AuditingStatusesForDisplay)(FileLists[0].AuditingStatus), pageIndex = "{0}" })));
        %>
    </div>
</div>

<script type="text/javascript">

    $(document).ready(function() {
        $('a.nyroModal').nyroModal({
            resizeable: true,
            width: 30,
            height: 40,
            endRemove: function(elts, settings) {
                $('#ListConvertibleGifts').parent().load('<%=SPBUrlHelper.Action("ShowConsigneeInfo","Auxiliaries")%>');
            }
        });
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
    });

</script>

