﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Dictionary<int, RecommendationType>>" %>
<%if (TempData["StatusMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
      if (messageType == StatusMessageType.Success)
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
      else
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
      TempData["StatusMessageType"] = null;
  }
  Dictionary<int, Application> applications = ViewData["Applications"] as Dictionary<int, Application>;
  Dictionary<string, Language> languages = Languages.GetLanguages(false);
%>
<div id="ListRecommendationTypes"> 
    <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
             <th class="tn-border-gray tn-border-bottom tn-text-note">
                类别ID
            </th>
             <th class="tn-border-gray tn-border-bottom tn-text-note">
                类别名称
            </th>
            <%foreach (Language language in languages.Values)
              { %>
             <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=language.NativeName %>
            </th>
            <%} %>
             <th class="tn-border-gray tn-border-bottom tn-text-note">
                对象
            </th>
             <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Description")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                操作
            </th>
        </tr>
        <%foreach (KeyValuePair<int, RecommendationType> pair in ViewData.Model)
          { %>
       <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=pair.Key %>
            </td>
             <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=StringUtils.Trim( pair.Value.Name,10) %>
            </td>
            <%foreach (string languageCode in languages.Keys)
              {%>
             <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%if (pair.Value.RecommendationTypeRes != null && pair.Value.RecommendationTypeRes.ContainsKey(languageCode)) { Response.Write(pair.Value.RecommendationTypeRes[languageCode]); } else { Response.Write("未填"); } %>
            </td>
            <%} %>
             <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <% if (applications.ContainsKey(pair.Value.ApplicationID)) Response.Write(applications[pair.Value.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage)); %>
            </td>
             <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=StringUtils.Trim(pair.Value.Description,30) %>
            </td>
             <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <a name="updateButton" href="<%=Url.Action("Control_EditRecommendationType", "Auxiliaries",new{typeID= pair.Key })%>"
                    class="submit recommendationTypeModal">编辑</a> 
                <a name="deleteButton" href="javascript:;"
                        onclick="if (confirm('确认要删除这个信息推荐类别吗？')) $('#ListRecommendationTypes').parent().load('<%=Url.Action("DeleteRecommendationType", "Auxiliaries", new {typeID= pair.Key})%>');">删除</a>
                        
            </td>
        </tr>
        <%} %>
    </table>

    <script type="text/javascript">
        $(document).ready(function() {
            $('a.recommendationTypeModal').nyroModal({
                resizeable: true,
                endRemove: function(elts, settings) {
                    $('#ListRecommendationTypes').parent().load('<%=Url.Action("Control_ManageRecommendationTypes", "Auxiliaries")%>');
                }
            });
            
        });        
    </script>

</div>
