﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<RecommendedItem>>" %>
<% 
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        else
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        TempData["StatusMessageType"] = null;
    }
    Dictionary<int, RecommendationType> types = ViewData["RecommendationTypeDictionary"] as Dictionary<int, RecommendationType>;
    int? commendTypeID = null;
    if (ViewData["CommendTypeID"] != null)
        commendTypeID = (int)ViewData["CommendTypeID"];
    int pageIndex = ViewData.GetInt("PageIndex", 1);   
%>
<div id="ListRecommendedItems">
    <%--<select id="reCommendedItemType" name="reCommendedItemType" class="tn-dropdownlist">
        <option value="">所有类别</option>
        <% foreach (KeyValuePair<int, RecommendationType> pair in types)
           {%>
        <option value="<%=pair.Key %>">
            <%=pair.Value.Name %></option>
        <%} %>
    </select>--%>
    <div class="tn-directory">
        <div class="tn-directory-level tn-border-gray tn-border-bottom">
            <span class="tn-directory-item <%if (commendTypeID == null || commendTypeID <= 0) Response.Write(" tn-text-note tn-selected"); %>">
                <a href="javascript:;" onclick=" $('#ListRecommendedItems').parent().load('<%=SPBUrlHelper.Action("Control_ManageRecommendedItems", "Auxiliaries")%>')">
                    全部</a></span>
            <% foreach (KeyValuePair<int, RecommendationType> pair in types)
               {%>
            <span class="tn-directory-item <%if (commendTypeID == pair.Key) Response.Write(" tn-text-note tn-selected"); %>">
                <a href="javascript:;" title="<%=pair.Value.Name %>" onclick=" $('#ListRecommendedItems').parent().load('<%=SPBUrlHelper.Action("Control_ManageRecommendedItems", "Auxiliaries", new RouteValueDictionary { { "commendTypeID", pair.Key } })%>')">
                    <%=pair.Value.Name%></a><em class="tn-text-note"></em></span>
            <%} %>
        </div>
    </div>
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                排序序号
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                推荐主题
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                推荐类别
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                应用对象
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                推荐人
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                推荐日期
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                过期时间
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                操作
            </th>
        </tr>
        <%
            string itemUrl = string.Empty;
            foreach (RecommendedItem item in ViewData.Model.Records)
            {
                if (item != null)
                {
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=item.DisplayOrder %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%
                    if (item.ApplicationID == ApplicationIDs.Instance().Blog())
                        itemUrl = SPBUrlHelper.Action("ShowBlogThread", "Blog", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(item.AuthorUserID) }, { "threadID", item.ItemID } });
                    else if (item.ApplicationID == ApplicationIDs.Instance().File())
                        itemUrl = SPBUrlHelper.Action("ShowFile", "ChannelFile", new RouteValueDictionary { { "threadID", item.ItemID } });
                    else if (item.ApplicationID == ApplicationIDs.Instance().Club())
                        itemUrl = SiteUrls.Instance().ClubDomainHome(item.ItemID);
                    else if (item.ApplicationID == ApplicationIDs.Instance().Event())
                        itemUrl = SPBUrlHelper.Action("ShowEvent", "ChannelEvent", new RouteValueDictionary { { "eventID", item.ItemID } });
                    else if (item.ApplicationID == ApplicationIDs.Instance().Photo())
                        itemUrl = SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(item.AuthorUserID) }, { "threadID", item.ItemID } });
                    else if (item.ApplicationID == ApplicationIDs.Instance().User())
                        itemUrl = SiteUrls.Instance().UserDomainHome(item.AuthorUserID);
                    else if (item.ApplicationID == ApplicationIDs.Instance().News())
                        itemUrl = SiteUrls.Instance().ShowNews(item.ItemID);

                    if (string.IsNullOrEmpty(itemUrl))
                        Response.Write(StringUtils.Trim(item.ItemName, 36));
                    else
                        Response.Write("<a href=\"" + itemUrl + "\"  target=\"_blank\">" + StringUtils.Trim(item.ItemName, 36) + " </a>");
                %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=item.RecommendedTypeName %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=item.ApplicationName %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=item.Commender %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=Formatter.FormatDate(item.DateCreated) %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=Formatter.FormatDate(item.Deadline) %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%//=SiteUrls.Instance().RecommendItem(item.ApplicationID,item.AuthorUserID, item.ItemID, item.ItemName)%>
                <a name="updateButton" href="<%=SPBUrlHelper.Action("Control_RecommendItem", "Channel", new RouteValueDictionary { { "applicationID", item.ApplicationID }, { "itemID", item.ItemID }, { "itemName",WebUtils.UrlEncode(item.ItemName) }, { "domainUserID", item.AuthorUserID }, { "CommendTypeID", item.CommendTypeID },{"CommendID",item.CommendID} })%>"
                    class="submit recommendModal">编辑</a> <a href="javascript:;" onclick="if (confirm('确认要删除这个信息推荐吗？')) $('#ListRecommendedItems').parent().load('<%=Url.Action("DeleteRecommendedItem", "Auxiliaries", new {commendID= item.CommendID,commendTypeID=commendTypeID,pageIndex=pageIndex})%>');">
                        删除</a>
            </td>
        </tr>
        <%}
            }%>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ManageRecommendedItems", "Auxiliaries", new RouteValueDictionary{ {"commendTypeID",commendTypeID},{"pageIndex", "{0}" }}), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#reCommendedItemType").val("<%=commendTypeID %>");
            $('a.recommendModal').nyroModal({
                resizeable: true,
                endRemove: function(elts, settings) {
                    $('#ListRecommendedItems').parent().load('<%=Url.Action("Control_ManageRecommendedItems", "Auxiliaries",new{commendTypeID=commendTypeID,pageIndex=pageIndex})%>');
                }
            });
            $('.tn-table-grid-row').hover(function() {
                $(this).addClass('tn-bg-gray');
            }, function() {
                $(this).removeClass('tn-bg-gray');
            });
            //            $("#reCommendedItemType").change(function() {
            //                $('#ListRecommendedItems').parent().load('<%=Url.Action("Control_ManageRecommendedItems", "Auxiliaries")%>', { commendTypeID: $("#reCommendedItemType").attr("value") });
            //            });
        });
        function pageIndexChange(url) {
            $('#ListRecommendedItems').parent().load(url);
        }
    </script>

</div>
