﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PrivateMessageInboxItem>>" %>
<% if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       if (messageType == StatusMessageType.Success)
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
       else
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
       TempData["StatusMessageType"] = null;
   }
%>
<form id="MessageInBoxForm" method="post">
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-message-list">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-list-header tn-border-gray tn-border-bottom">
            <div class="tn-toolbar-area tn-helper-clearfix">
                <span class="tn-text-note tn-count tn-helper-right">共<%=ViewData.Model.TotalRecords %>封私信
                    /
                    <%=ViewData.GetInt("NoReadCount",0) %>封未读</span>
                <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'MessageInBoxCheckBoxGroup')" />
                <label for="TopCheckBox">
                    <%=GetResourceString("Label_SelectAllOrNo") %></label>
                <%=SPBHtmlHelper.Instance().LinkButton("SetMessageRead", "标记为已读", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary { { "title", "把选中的消息标记为已读" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("SetMessageNoRead", "标记为未读", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "把选中的消息标记为未读" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("DeleteInBoxMessages", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "删除选中的消息" } }, null)%>
            </div>
        </div>
        <table class="tn-table-grid">
            <tbody>
                <%foreach (PrivateMessageInboxItem message in ViewData.Model.Records)
                  { %>
                <tr class="tn-table-grid-row <% if (!message.IsRead) Response.Write(" tn-unread"); %>">
                    <td class="tn-border-gray tn-border-bottom tn-width-check">
                        <input type="checkbox" name="MessageInBoxCheckBoxGroup" class="tn-checkbox" value="<%=message.ThreadID %>" />
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-avatar">
                        <div class="tn-avatar">
                            <% if (message.MessageType == PrivateMessageType.Serve)
                               { %>
                            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                                width="46" height="46" /><span class="tn-round-corner"></span>
                            <%}
                               else if (message.MessageType == PrivateMessageType.System)
                               {%>
                            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/SystemAvatar.gif") %>"
                                width="46" height="46" /><span class="tn-round-corner"></span>
                            <% }
                               else
                               {
                                   if (message.SenderUserID > 0)
                                   { %>
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(message.SenderUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                            <%}
                               }%>
                        </div>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-user-name">
                        <cite><a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(message.SenderUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                            title="查看<%=message.Sender %>的个人空间">
                            <%=message.Sender %></a> </cite><em class="tn-date tn-text-note">
                                <%=Formatter.FormatFriendlyDate(message.MostRecentPostDate) %></em>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                        <% if (!message.IsRead)
                           {
                               Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Email));
                           }
                           else
                           {
                               Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.EmailOpen));
                           } %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-auto">
                        <cite><a class="tn-subject" href="<%=Url.Action("ShowMessage","Auxiliaries",new{threadID=message.ThreadID}) %>"
                            title="<%=message.MostRecentPostSubject %>">
                            <%=StringUtils.Trim(message.MostRecentPostSubject, 30) %></a></cite><span title="<%=message.MostRecentPostBody %>"
                                class="tn-snippet">
                                <%=HtmlUtils.TrimHtml(message.MostRecentPostBody, 40)%></span>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-icon2">
                        <%if (!message.IsLocked)
                          { %>
                        <%=SPBHtmlHelper.Instance().LinkButton("reply", SPBUrlHelper.Action("ShowMessage", "Auxiliaries", new RouteValueDictionary { { "threadID", message.ThreadID } })+"#reply", HighlightStyles.Lite, IconTypes.Bubble)%>
                        <%} %>
                        <% int returnToPageIndex = ViewData.Model.PageIndex;
                           if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
                           {
                               returnToPageIndex = ViewData.Model.PageIndex - 1;
                           } %>
                        <%=SPBHtmlHelper.Instance().LinkButton("del",HighlightStyles.Lite,IconTypes.Cross,new RouteValueDictionary {{"onclick","if (confirm('确定要删除该消息吗？')) $('#MessageInBoxDiv').load('"+Url.Action("DeleteInBoxMessage","Auxiliaries",new {threadID=message.ThreadID,pageIndex=returnToPageIndex})+"'); return false;"}},null) %>
                    </td>
                </tr>
                <%} %>
            </tbody>
        </table>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_MessageInBox", "Auxiliaries", new RouteValueDictionary { { "pageIndex", "{0}" } }), "pageIndexChange")%>
        </div>
    </div>
</div>
</form>

<script type="text/javascript">



    function pageIndexChange(url) {
        $('#MessageInBoxDiv').load(url);
    }
    $(document).ready(function() {
        $("#SetMessageRead").click(function() {
            $('#MessageInBoxForm')
          .ajaxSubmit({ target: '#MessageInBoxDiv', url: '<%=Url.Action("SetMessageReadStatus","Auxiliaries",new {isread=true,pageIndex=Html.GetParameterFromRouteDateOrQueryString("PageIndex")}) %>' })
        });
        $("#SetMessageNoRead").click(function() {
            $('#MessageInBoxForm')
          .ajaxSubmit({ target: '#MessageInBoxDiv', url: '<%=Url.Action("SetMessageReadStatus","Auxiliaries",new {isread=false,pageIndex=Html.GetParameterFromRouteDateOrQueryString("PageIndex")}) %>' })
        });
        $("#DeleteInBoxMessages").click(function() {
            if (confirm('确认要删除这些消息吗？'))
                $('#MessageInBoxForm')
        .ajaxSubmit({ target: '#MessageInBoxDiv', url: '<%=Url.Action("DeleteInBoxMessages","Auxiliaries") %>' })
        });
    })   
</script>

