﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PrivateMessageOutboxItem>>" %>
<% if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       if (messageType == StatusMessageType.Success)
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
       else
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
       TempData["StatusMessageType"] = null;
   }
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-message-list">
    <div class="tn-box-content tn-widget-content tn-corner-all" id="ListMessageOutBoxDiv">
        <form id="MessageOutBoxForm" method="post">
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'MessageOutBoxCheckBoxGroup')" />
                <label for="TopCheckBox">
                    <%=GetResourceString("Label_SelectAllOrNo") %></label>
                <%=SPBHtmlHelper.Instance().LinkButton("DeleteOutBoxMessages", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "删除选中的消息" } }, null)%>
            </div>
        </div>
        <table class="tn-table-grid">
            <tbody>
                <%foreach (PrivateMessageOutboxItem message in ViewData.Model.Records)
                  { %>
                <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-width-check">
                        <input type="checkbox" name="MessageOutBoxCheckBoxGroup" class="tn-checkbox" value="<%=message.ThreadID %>" />
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-avatar">
                        <div class="tn-avatar">
                            <span class="tn-round-corner"></span>
                            <% if (message.MessageType == PrivateMessageType.Serve)
                               { %>
                            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                                width="46" height="46" /><span class="tn-round-corner"></span>
                            <%}
                               else
                               {
                                   if (message.ReceiverUserID > 0)
                                   { %>
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(message.ReceiverUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small, new RouteValueDictionary { { "class","tn-round-corner"} })%>
                            <%}
                               }%>
                        </div>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-user-name">
                        <cite>至：<a class="tn-user-name" target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(message.ReceiverUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                            title="查看<%=message.Receiver %>的个人空间">
                            <%=message.Receiver%></a></cite> <em class="tn-date tn-text-note">
                                <%=Formatter.FormatFriendlyDate(message.MostRecentPostDate) %>
                            </em>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-auto">
                        <cite><a class="tn-subject" href="<%=Url.Action("ShowMessage","Auxiliaries",new{threadID=message.ThreadID}) %>"
                            title="<%=message.MostRecentPostSubject %>">
                            <%=StringUtils.Trim(message.MostRecentPostSubject, 30) %></a></cite><span class="tn-snippet">
                                <label title="<%=message.MostRecentPostBody %>">
                                    <%=HtmlUtils.TrimHtml(message.MostRecentPostBody, 40) %></span>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-icon2">
                        <%if (!message.IsLocked)
                          { %>
                        <%=SPBHtmlHelper.Instance().LinkButton("reply", SPBUrlHelper.Action("ShowMessage", "Auxiliaries", new RouteValueDictionary { { "threadID", message.ThreadID } })+"#reply", HighlightStyles.Lite, IconTypes.Bubble)%>
                        <%} %>
                        <% int returnToPageIndex = ViewData.Model.PageIndex;
                           if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
                           {
                               returnToPageIndex = ViewData.Model.PageIndex - 1;
                           } %>
                        <%=SPBHtmlHelper.Instance().LinkButton("del",HighlightStyles.Lite,IconTypes.Cross,new RouteValueDictionary {{"onclick","if (confirm('确定要删除该消息吗？')) $('#MessageOutBoxDiv').load('"+Url.Action("DeleteOutBoxMessage","Auxiliaries",new {threadID=message.ThreadID,pageIndex=returnToPageIndex})+"');return false;"}},null) %>
                </tr>
                <%} %>
            </tbody>
        </table>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_MessageOutBox", "Auxiliaries", new RouteValueDictionary { { "pageIndex", "{0}" } }), "pageIndexChange")%>
        </div>
        </form>
    </div>
</div>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#MessageOutBoxDiv').load(url);
    }
    $(document).ready(function() {
        $("#DeleteOutBoxMessages").click(function() {
            if (confirm('确认要删除这些消息吗？'))
                $('#MessageOutBoxForm')
        .ajaxSubmit({ target: '#MessageOutBoxDiv', url: '<%=Url.Action("DeleteOutBoxMessages","Auxiliaries") %>' })
        });
    })   
</script>

