﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<User>" %>

<div class="commonContentArea">
  <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            if (messageType == StatusMessageType.Success)
            {
                //关闭模式窗口
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["StatusMessageType"] = null;
        }
        User toUser = ViewData.Model; %>
  <form class="nyroModal" id="newMessageForm" name="newMessageForm"
    action="<%=Url.Action("CreateMessage","Auxiliaries") %>" method="post">
    <div class="tn-form tn-label-right">
      <div class="tn-text-heading tn-border-gray tn-border-bottom">
        <h4> 发送站内信息</h4>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label">接收人：</label>
        <input type="hidden" id="receiverID" name="receiverID" value="<%= toUser.UserID %>" />
        <%=toUser.DisplayName %> </div>
      <div class="tn-form-row">
        <label class="tn-form-label"><%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" id="subject" name="subject" class="tn-textbox tn-input-long tn-border-gray" />
        <%=GetResourceString("Description_Required")%> </div>
      <div class="tn-form-row">
        <label class="tn-form-label"><%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %></label>
        <textarea name="body" id="body" class="tn-textarea tn-input-long tn-border-gray"></textarea>
        <div class="tn-text-note"> 内容允许输入的最大字数为：3000字 </div>
      </div>
      <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label"> </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default,null, null)%> <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%> </div>
    </div>
  </form>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#newMessageForm").validate({
            rules: {
                subject: { required: true, maxBlength: 30 },
                body: { required: true, maxBlength: 3000 }
            },
            messages: {
                subject: { required: "请填写消息标题", maxBlength: "消息标题最大长度不允许超过30个字" },
                body: { required: "请填写消息内容", maxBlength: "消息内容最大长度不能超过3000字" }
            }
        });

        $("#sendButton").click(function() {
            if (!$("#newMessageForm").valid()) {
                return false;
            }
        });
    });
</script>
