﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PrivateMessage>" %>
<% PrivateMessage message = ViewData.Model;
   
   PrivateMessagePost post = new PrivateMessagePost();
   post.PostID = message.PostID;
   post.Subject = message.Subject;
   post.Author = message.Sender;
   post.Body = message.Body;
   post.UserID = message.SenderUserID;
   post.PostDate = message.PostDate;
   List<PrivateMessagePost> list = new List<PrivateMessagePost>();
   list.Add(post);
   list.AddRange(message.Replies); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-show-message">
  <div class="tn-box-content tn-widget-content tn-corner-all">
    <div class="tn-text-heading">
      <h4> <%=message.Subject %></h4>
    </div>
    <div class="tn-list-header tn-border-gray tn-border-bottom">
      <div class=" tn-list-header-row tn-text-note">
        <% if (message.MessageType != PrivateMessageType.System)
                   { %>
        参与者： 客服人员 和 <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(message.ReceiverUserID>0?message.ReceiverUserID:message.SenderUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                    id="receiver"> <%= message.ReceiverUserID>0?message.Receiver:message.Sender %></a>
        <%} %>
      </div>
    </div>
    <table class="tn-table-grid">
      <tbody>
        <% foreach (PrivateMessagePost item in list)
                   {
                %>
        <tr class="tn-table-grid-row">
          <td class="tn-border-gray tn-border-bottom tn-width-avatar"><div class="tn-avatar">
              <% if (item.UserID == (int)PrivateMessageEspecialUserID.Serve)
                               { %>
              <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                                width="46" height="46" /><span class="tn-round-corner"></span>
              <%}
                               else if (item.UserID == (int)PrivateMessageEspecialUserID.System)
                               {%>
              <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/SystemAvatar.gif") %>"
                                width="46" height="46" /><span class="tn-round-corner"></span>
              <% }
                               else
                               {
                                   if (item.UserID > 0)
                                   { %>
              <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,new RouteValueDictionary {{"class","tn-round-corner"}})%>
              <%}
                               }%>
            </div></td>
          <td class="tn-border-gray tn-border-bottom tn-width-user-name"><cite>
            <% if (item.UserID > 0)
                               { %>
            <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                title="查看<%=item.Author %>的个人空间"> <%=item.Author %></a>
            <%}
                               else Response.Write(item.Author); %>
            </cite><em class="tn-date tn-text-note"> <%=Formatter.FormatFriendlyDate(item.PostDate) %></em></td>
          <td class="tn-border-gray tn-border-bottom tn-width-auto"><%=item.Body%></td>
        </tr>
        <%} %>
      </tbody>
    </table>
    <%
            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                if (messageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                TempData["StatusMessageType"] = null;
            }

            if (!message.IsLocked)
            { %>
    <form id="replyMessageForm" action="<%=Url.Action("ReplyMessage","Auxiliaries",new {threadID=Request.QueryString.GetInt("ThreadID",0)}) %>"
        method="post">
      <div class="tn-form tn-label-right spb-message-form">
        <div class="tn-form-row tn-emotion-box">
          <label class="tn-form-label"> 回复：</label>
          <a name="reply"></a>
          <div class="tn-emotion-textarea tn-textarea-wrap">
            <textarea name="body" id="body" cols="" rows="" class="tn-textarea tn-input-longest tn-border-gray"></textarea>
            <span style="display:none"></span>
          </div>
          <div class="tn-text-note tn-helper-clear"> 内容允许输入的最大字数为：3000字 </div>
        </div>
        <div class="tn-form-row tn-form-row-button">
          <label class="tn-form-label"></label>
          <input type="submit" value="回复" />
          <a href="<%=Url.Action("MessageInBox", "Auxiliaries") %>">返回收件箱</a> </div>
      </div>
    </form>
    <script type="text/javascript">
            $(document).ready(function() {
                $("#replyMessageForm").validate({
                    rules: {
                        body: { required: true, maxBlength: 3000 }
                    },
                    messages: {
                        body: { required: "请填写回复内容", maxBlength: "内容最长不能超过3000个字" }
                    }
                });

                $('#replyMessageForm').ajaxForm({
                    beforeSubmit: function() { if (!$("#replyMessageForm").valid()) { return false; } },
                    target: '#showMessage',
                    success: function() { $('#body').attr('value', ''); }
                });

            }); 
        </script>
    <%} %>
  </div>
</div>
