﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<BlogThreadType>" %>

<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
        }
        else if (messageType == StatusMessageType.Error)
        {
            Response.Write(string.Format("操作失败：{0}", TempData.GetString("StatusMessageContent", "未知错误")));
        }
        TempData["StatusMessageType"] = null;
    }   
%>
<form class="nyroModal" id="UpdateBlogThreadTypeForm" method="post" action="<%=Url.Action("UpdateBlogThreadType", "ManageBlog", new { typeID=ViewData.Model.TypeID })%>">
<div class="tn-form tn-label-right">
  <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
    添加编辑文章分类</h4>
  <p class="tn-text-note">
    请添加或修改以下详细信息</p><br />
    <div class="tn-form-row">
        <label class="tn-form-label">
            类别名称：</label>
        <input type="text" class="textBox" name="typeName" id="typeName" value="<%=ViewData.Model.TypeName %>" /><span
            class="tn-form-required">*</span>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input type="submit" id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
        <input type="reset" class="nyroModalClose" id="cancelButton" value="<%=GetResourceString("Button_Cancel") %>" />
    </div>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $("#UpdateBlogThreadTypeForm").validate({
            rules: {
                typeName: { required: true, maxBlength: 64 }
            },
            messages: {
                typeName: { required: "请填写文章类型名称", maxBlength: "文章类型名称的最大长度不能超过64字" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#UpdateBlogThreadTypeForm").valid()) {
                return false;
            }
        });
    });
</script>

