﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogThread>>" %>
<div id="ManageBlogsDiv">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom">
                <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Subject")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                作者
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_SiteDivisionCategory")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                精华
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                置顶
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_PrivacySetting")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_PostDate")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Actions")%>
            </th>
        </tr>
        <%
            if (ViewData.Model != null)
            {
                PagingDataSet<BlogThread> PgListBlogArticle = ViewData.Model as PagingDataSet<BlogThread>;
                IList<BlogThread> IListBlogArticle = PgListBlogArticle.Records;                
        %>

        <script type="text/javascript">
            $(document).ready(function() {
                $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
                $('a[name="BlogManagerCommend"]').nyroModal({
                    resizeable: true,
                    height: 450,
                    width: 400
                });
            });
        </script>

        <% if (ViewData.Model.Records.Count > 0)
           {
               foreach (var item in IListBlogArticle)
               {    
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox"
                    value="<%=item.ThreadID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <a href="<%=Url.Action("ShowBlogThread", "Blog", new {userDomainName=UserID2UserNameDictionary.GetUserName(item.OwnerUserID),threadID=item.ThreadID })%>"
                    target="_blank">
                    <%=StringUtils.Trim(item.Subject, 30)%></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <a href="<%=SiteUrls.Instance().UserChannelHome(item.OwnerUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                    target="_blank">
                    <%=item.Author%></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                <% if (item.SiteCategory != null)
                   {%>
                <a href="<%=Url.Action("ListBlogThreadsByCategory","ChannelBlog",new RouteValueDictionary {{"categoryID",item.SiteCategoryID}})  %>"
                    target="_blank">
                    <%=item.SiteCategory.CategoryName%></a>
                <%} %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                <% if (item.IsEssential)
                   {
                       Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept));
                   }
                   else
                   { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); } %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                <% if (item.SpecialOrder > 0)
                   {
                       Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept));
                   }
                   else
                   { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); } %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                <% switch (item.PrivacyStatus)
                   {
                       case PrivacyStatuses.NeedPassword:
                           Response.Write("凭密码访问");
                           break;
                       case PrivacyStatuses.OnlyFriend:
                           Response.Write("仅好友可见");
                           break;
                       case PrivacyStatuses.Privacy:
                           Response.Write("仅自己可见");
                           break;
                       case PrivacyStatuses.Public:
                           Response.Write("所有人可见");
                           break;
                       default:
                           break;
                   } %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                <%=Formatter.FormatDate(item.PostDate)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                    menu="#moreOptions3<%=item.ThreadID %>"><span class="tn-icon tn-icon-triangle-down">
                    </span><a href="<%=Url.Action("EditBlogThread","Blog",new RouteValueDictionary {{"userDomainName",UserID2UserNameDictionary.GetUserName(item.OwnerUserID)},{"threadID",item.ThreadID}}) %>"
                        class="tn-action-text" target="_blank">编辑</a> </span>
                <div id="moreOptions3<%=item.ThreadID %>" class="tn-drop-menu ui-widget-content"
                    style="display: none;">
                    <ul class="tn-menu-drop-list">
                        <li class="tn-menu-drop-item"><a onclick="if ( !confirm('是否删除选中的文章？') ) {return false; }"
                            href="<%=Url.Action("DeleteBlogArticle", "ManageBlog", new { status = (AuditingStatusesForDisplay)(item.AuditingStatus), pageIndex = PgListBlogArticle.PageIndex, threadID = item.ThreadID }) %>">
                            删除</a> </li>
                        <li class="tn-menu-drop-item"><a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Blog(), item.OwnerUserID,item.ThreadID,item.Subject)%>"
                            name="BlogManagerCommend">推荐</a> </li>
                    </ul>
                </div>
            </td>
        </tr>
        <%}
           } %>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%
            Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgListBlogArticle.TotalRecords, PgListBlogArticle.PageSize, PgListBlogArticle.PageIndex, 11, null)); 
        %>
    </div>
    <%} %>
</div>

 <script type="text/javascript">
     $(document).ready(function() {
         $('.tn-table-grid-row').hover(function() {
             $(this).addClass('tn-bg-gray');
         }, function() {
             $(this).removeClass('tn-bg-gray');
         });
     });  
 </script>
