﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogComment>>" %>
<div id="ManageFileCommentDiv">
   <table class="tn-table-grid">
   <tbody>
          <tr class="tn-table-grid-header">
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    <%=GetResourceString("Label_Body")%>
                </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                    评论文章
                </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                    
                </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_CommentDate") %>
                </th>
            </tr>
            <%
                if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
                {
                    PagingDataSet<BlogComment> PgCommentDataSet = ViewData.Model as PagingDataSet<BlogComment>;
                    IList<BlogComment> CommentLists = PgCommentDataSet.Records;
                    foreach (var item in CommentLists)
                    {
                        string commentedUserName = UserID2UserNameDictionary.GetUserName(item.OwnerUserID);
            %> <tr class="tn-table-grid-row">
               <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" name="CheckBoxGroup" id="CheckBoxGroup" value="<%=item.PostID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                    <a target="_blank" href="<%=string.Format("{0}#{1}",Url.Action("ShowBlogThread", "Blog", new { userDomainName = commentedUserName , threadID=item.ThreadID}),item.PostID)  %>" title="<%=HtmlUtils.TrimHtml(item.Body,300) %>">
                        <%=HtmlUtils.TrimHtml(item.Body,50) %></a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <% BlogThread blogThread = BlogThreads.GetThread(item.ThreadID, null,true);
                       if (blogThread != null)
                       {%>
                    <a target="_blank" href="<%=Url.Action("ShowBlogThread", "Blog", new { userDomainName = commentedUserName , threadID=item.ThreadID}) %>" title="<%=blogThread.Subject %>">
                        <%=HtmlUtils.TrimHtml(blogThread.Subject, 30)%></a>
                    <%} %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                    <%if (item.UserID > 0)
                      { %>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                        <%=item.Author%></a>
                    <%
                        }
                      else
                      {
                          Response.Write(item.Author);
                      }
                    %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <%=Formatter.FormatDate(item.PostDate) %>
                </td>
            </tr>
            <% }%>
        </tbody>
    </table>
    <div class="tn-pagination tn-helper-align-center">
            <% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgCommentDataSet.TotalRecords, PgCommentDataSet.PageSize, PgCommentDataSet.PageIndex, 11, null));   %>
        </div>
    </div>
    <%
        }
                else
                {
    %>
    </tbody> </table>
    <%} %>
</div>
