﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();refresh();</script>"));
        }
        else if (messageType == StatusMessageType.Error)
        {
            //Response.Write(TempData.GetString("StatusMessageContent", string.Empty));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        }
        TempData["StatusMessageType"] = null;
    }   
%>
<%Club changeClub = ViewData["ChangeClub"] as Club; %>
<form id="editor" action="<%=this.Url.Action("ChangeClubOwnerAction", "ManageClub", new { clubID=changeClub.ClubID})%>"
method="post" class="nyroModal">
<div class="tn-form-box">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        更换群主
    </h4>
    <table>
        <tr>
            <td>
                当前群主：
            </td>
            <td class="commonFormField">
                <%=changeClub.ClubOwner.UserName %>
            </td>
        </tr>
        <tr>
            <td>
                新群主用户名：
            </td>
            <td>
                <input type="text" name="newClubOwner" id="newClubOwner" class="tn-textbox tn-input-medium  tn-border-gray"
                    maxlength="100" /><span class="tn-form-required">*</span>
            </td>
        </tr>
        <tr>
            <td>
            </td>
            <td>
                <input type="submit" id="EditUserTagSubmitButton" value="<%=GetResourceString("Button_OK")%>" />
                <input type="button" class="nyroModalClose" value="<%=GetResourceString("Button_Cancel")%>" />
            </td>
        </tr>
    </table>
</div>
</form>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#editor").validate({
            rules: {
                newClubOwner: "required"
            },
            messages: {
                newClubOwner: "请填写用户名"
            }
        });

        $("#EditUserTagSubmitButton").click(function() {
            if (!$("#editor").valid()) {
                return false;
            }
        });
    }); 
</script>

