﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<SiteCategory>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    Dictionary<string, Language> languages = Languages.GetLanguages(false); 
%>
<form class="nyroModal" id="EditCategoryForm" method="post" action="<%=Url.Action("UpdateSiteCategory", "Manage", new {applicationID=ViewData.GetInt("ApplicationID", 0), categoryID = (int?)ViewData["CategoryID"],parentID=(int?)ViewData["ParentID"] })%>">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        添加编辑类别</h4>
    <% if (Request.QueryString.GetInt("ParentID", -1) > 0)
       { %>
    <div class="tn-form-row">
        <label class="tn-form-label">
            父类别名称：</label>
        <%=ViewData.GetString("ParentCategoryName", string.Empty)%>
    </div>
    <%} %>
    <div class="tn-form-row">
        <label class="tn-form-label">
            类别名称：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="categoryName"
            id="categoryName" value="<%=ViewData.Model.CategoryName %>" />
        <span class="tn-form-required">(必填)</span>
    </div>
    <% foreach (Language language in languages.Values)
       { %>
    <div class="tn-form-row">
        <label class="tn-form-label">
            类别<%=language.NativeName%>名称：
        </label>
        <input name="CategoryName_<%=language.LanguageCode %>" id="CategoryName_<%=language.LanguageCode %>"
            type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<% if (Model.CategoryNameRes != null && Model.CategoryNameRes.ContainsKey(language.LanguageCode)) Response.Write(Model.CategoryNameRes[language.LanguageCode]); %>"
            maxlength="16" />
    </div>
    <%} %>
    <div class="tn-form-row">
        <label class="tn-form-label">
            排序序号：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="displayOrder"
            name="displayOrder" maxlength="256" value="<%=ViewData.Model.DisplayOrder %>" />
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton",GetResourceString("Button_Save"),ButtonSizes.Default,null,null) %>
        <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "class", "nyroModalClose" }})%>
    </div>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $("#EditCategoryForm").validate({
            rules: {
                categoryName: { required: true, maxBlength: 16 },
                displayOrder: { digits: true }
            },
            messages: {
                categoryName: { required: "请填写站点类别的名称", maxBlength: "站点类别名称的最大长度不能超过16字" },
                displayOrder: { digits: "请输入数字" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#EditCategoryForm").valid()) {
                return false;
            }
        });
    });
</script>

