﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FileThread>>" %>
<div id="ManageFileListsDiv">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom">
                <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                文件名称
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                发布者
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                站点分类
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                精华
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                置顶
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_PrivacySetting")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Hit", ApplicationIDs.Instance().File())%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_PostDate")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Actions")%>
            </th>
        </tr>
        <%
            if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
            {
                PagingDataSet<FileThread> PgFilelists = ViewData.Model as PagingDataSet<FileThread>;
                IList<FileThread> FileLists = PgFilelists.Records;                
        %>

        <script type="text/javascript"> 
         $(document).ready(function(){
            $('a[name="fileManagerCommend"]').nyroModal({
            resizeable: true,
            height: 450,
            width: 400,
            endRemove: function(elts, settings) {
             //   $('#ManageFileListsDiv').load('<%=Url.Action("Control_ListFiles","ManageFile", new { status = (AuditingStatusesForDisplay)(FileLists[0].AuditingStatus), pageIndex = PgFilelists.PageIndex }) %>');
             refresh();  
            }
        });
        });
        </script>

        <%
          
            foreach (var item in FileLists)
            {    
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox" value="<%=item.ThreadID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(item.FileName, ContentTypeThumbnailSize.Small)%>
                &nbsp; <a title="<%=item.Subject %>" href="<%=Url.Action("ShowFile","ChannelFile",new{threadID=item.ThreadID}) %>"
                    target="_blank">
                    <%=StringUtils.Trim(item.Subject,35)%></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <a href="<%=SiteUrls.Instance().UserChannelHome(item.OwnerUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                    target="_blank">
                    <%=item.Author%></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                <% if (item.SiteCategory != null)
                   {%>
                <a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "SiteCategoryID", item.SiteCategoryID }})%>">
                    <%=item.SiteCategory.CategoryName%></a>
                <%} %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                <% if (item.IsEssential)
                   {
                       Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept, "此文件已设为精华"));
                   }
                   else
                   {
                       Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross, "此文件未设为精华"));
                   } %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                <% if (item.SpecialOrder > 0)
                   {
                       Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept, "此文件已设为置顶"));
                   }
                   else
                   {
                       Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross, "此文件未设为置顶"));
                   } %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                <% switch (item.PrivacyStatus)
                   {
                       case PrivacyStatuses.NeedPassword:
                           Response.Write("凭密码访问");
                           break;
                       case PrivacyStatuses.OnlyFriend:
                           Response.Write("仅好友可见");
                           break;
                       case PrivacyStatuses.Privacy:
                           Response.Write("仅自己可见");
                           break;
                       case PrivacyStatuses.Public:
                           Response.Write("所有人可见");
                           break;
                       default:
                           break;
                   } %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <%=item.Attachment.Friendlylength%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                <%=Formatter.FormatDate(item.PostDate)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                    menu="#moreOptions3_<%=item.ThreadID %>"><span class="tn-icon tn-icon-triangle-down">
                    </span><a class="tn-action-text" href="<%=SiteUrls.Instance().RecommendItem( ApplicationIDs.Instance().File(),item.OwnerUserID, item.ThreadID,item.Subject)%>"
                        name="fileManagerCommend" >推荐</a> </span>
                <div id="moreOptions3_<%=item.ThreadID %>" class="tn-drop-menu ui-widget-content"
                    style="display: none;">
                    <ul class="tn-menu-drop-list">
                        <li class="tn-menu-drop-item"><a  href="<%=Url.Action("EditFile", "File", new { userDomainName=UserID2UserNameDictionary.GetUserName(item.OwnerUserID), threadID =item.ThreadID})%>"
                            target="_blank">
                            <%=GetResourceString("Action_Edit")%></a></li>
                        <li class="tn-menu-drop-item"><a onclick="if ( !confirm('是否删除选中的文件？') ) {return false; }"
                            href="<%=Url.Action("DeleteFile", "ManageFile", new { status = (AuditingStatusesForDisplay)(item.AuditingStatus), pageIndex = PgFilelists.PageIndex,threadID=item.ThreadID }) %>"
                            >删除</a> </li>
                    </ul>
                </div>
            </td>
        </tr>
        <%} %>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%
            Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgFilelists.TotalRecords, PgFilelists.PageSize, PgFilelists.PageIndex, 11, null));
                // Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgFilelists.TotalRecords, PgFilelists.PageSize, PgFilelists.PageIndex, 11, Url.Action("ListManageFiles", "ManageFile", new { status = (AuditingStatusesForDisplay)(FileLists[0].AuditingStatus), pageIndex = "{0}" })));
        %>
    </div>
    <% 
        }
            else
            {
    %>
    </table>
    <%} %>
</div>
<%--<script type="text/javascript">
  function pageIndexChange(url)
  { 
    $('#ManageFileListsDiv').parent().load(url);
  }
</script>--%>

<script type="text/javascript">
    $(document).ready(function() {        
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
    });
</script>

