﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<div class="clubCreate">
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                //关闭模式窗口
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
            }
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessage", string.Empty)));
            TempData["StatusMessageType"] = null;
        }
        int categoryDepth = ViewData.GetInt("SiteCategoryLevel", 1) - 1;
        int areaLevel = ViewData.GetInt("AreaLevel", 2);
        string rootAreaCode = ViewData.GetString("rootAreaCode", string.Empty);
        Club club = ViewData["Club"] as Club;
        ForumSectionGroup sectionGroup = ViewData.Get<ForumSectionGroup>("ConvertForum", null);
    %>
    <form id="createClubForm" action="<%=Url.Action("ConvertForumGroupToClub", "ManageForum",new{clubID=club.ClubID,groupID=sectionGroup.GroupID})%>"
    method="post" class="nyroModal">
    <div class="tn-form tn-label-right">
        <div class="tn-text-heading tn-border-gray tn-border-bottom">
            <h4>
                填写群组信息，将论坛板块组转换为群组，其中<span class="tn-form-required"> * </span>
                号的为必填项</h4>
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                群组名称：</label>
            <input type="text" id="clubName" class="tn-textbox tn-input-medium tn-border-gray"
                name="clubName" value="<%=club.ClubID > 0 ? club.ClubName : sectionGroup.GroupName %>" />
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                个性网址：</label>
            http://
            <input type="text" id="clubDomain" class="tn-textbox tn-input-medium tn-border-gray"
                name="clubDomain" value="<%=club.DomainName %>" <% if(club.ClubID > 0) Response.Write("disabled=\"disabled\""); %> />
            <label id="clubDomainLabel2" class="error">
                恭喜,此网址可注册</label>
            <label id="clubDomainLabel" class="error">
                对不起,此网址已被注册</label>
            <% string clubFriendlyUrlPattern = ClubDomainConfiguration.Instance().FriendlyUrlPattern; %>
            <%=clubFriendlyUrlPattern.Substring(clubFriendlyUrlPattern.IndexOf('.'))%>
            <span class="tn-form-required">* </span>
            <br />
            <div class="tn-text-note">
                （个性网址设定后不允许修改，请填写 2-25 位字母或数字）</div>
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                群主用户名：</label>
            <input type="text" id="clubOwnerName" class="tn-textbox tn-input-medium tn-border-gray"
                name="clubOwnerName" value="<%=club.ClubOwnerUserID > 0 ? club.ClubOwner.UserName:string.Empty%>" /><span
                    class="tn-form-required"> * </span>
            <br />
            <div class="tn-text-note">
                （群主设置之后，可到群组管理当中更改）</div>
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                群组简介：</label>
            <textarea class="tn-textarea tn-input-text tn-input-long tn-border-gray" name="brief"
                id="brief"><%=club.Brief %></textarea>
            <span class="tn-form-required">* </span>
            <div class="tn-text-note">
                （请用简洁的语言对您的群组进行描述，字数限制为60字。简介在群组的顶部及群组列表中显示）</div>
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                群组类别：</label>
            <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Club(), categoryDepth, "categoryID", club.CategoryID, "dropDownList"));%>
            <span class="tn-form-required">*</span>
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                所在地区：</label>
            <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", rootAreaCode, club.AreaCode, areaLevel, "dropDownList")); %>
            <br />
            <div class="tn-text-note">
                （如果您的群组地区性质比较明显，请选择所在地区）</div>
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                公开程度：</label>
            <input type="radio" id="clubSecrecyTypePublic" name="clubSecrecyType" value="1" <%if (club.IsPublic) Response.Write("checked=\"checked\""); %> /><label
                for="clubSecrecyTypePublic">公开</label>
            <div class="tn-text-note">
                （群组内容对所有人公开并允许申请加入）</div>
            <label class="tn-form-label">
            </label>
            &nbsp; &nbsp; &nbsp;
            <input type="checkbox" id="needApproveCheckbox" name="needApproveCheckbox" value="false"
                <% if (club.IsMemberNeedAuthorize) Response.Write("checked=\"checked\"");%> /><label
                    for="needApproveCheckbox">（加入群组需要管理员批准）</label>
            <br />
            <label class="tn-form-label">
            </label>
            <input type="radio" id="clubSecrecyTypePrivate" name="clubSecrecyType" value="0"
                <%if (!club.IsPublic) Response.Write("checked=\"checked\""); %> /><label for="clubSecrecyTypePrivate"><%=GetResourceString("Enum_PrivacyStatuses_Privacy")%></label>
            <div class="tn-text-note">
                （仅成员才能看到群组，需邀请才可加入）</div>
        </div>
        <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label">
            </label>
            <input type="submit" value="转换为群组" id="saveButton" name="saveButton" />
            <% if (Request.UrlReferrer != null)
               {%>
            <a href="<%=Request.UrlReferrer.AbsoluteUri %>" class="inputCancel">
                <%=GetResourceString("Button_Cancel")%></a>
            <%} %>
        </div>
    </div>
    </form>

    <script type="text/javascript">

                        $(document).ready(function() {

                            $("#createClubForm").validate({
                                rules: {
                                    clubName: { required: true, rangelength: [1, 30] },
                                    clubDomain: { required: true, rangelength: [2, 25] },
                                    categoryID: { required: true, min: 1 },
                                    brief: { required: true, rangelength: [1, 60] },
                                    clubOwnerName: { required: true, rangelength: [2, 25] },
                                },
                                messages: {
                                    clubName: { required: "请输入群组名称", rangelength: "最大长度不能超过30字" },
                                    clubDomain: { required: "请输入群组域名", rangelength: "个性网址设定后不允许修改，请填写 2-25 位字母或数字" },
                                    categoryID: { required: "请选择一个类别", min: "请选择一个类别" },
                                    brief: { required: "请输入群组简介", rangelength: "最大长度不能超过60字" },
                                    clubOwnerName: { required: "请输入群主用户名", rangelength: "请填写正确的用户名" }
                                }
                            });
                        });


//                        var createClubFunction = function(saveButton) {
//                            if ($("#createClubForm").valid()) {
//                                saveButton.attr('style', 'display:none');
//                                $("#saveButtonA").attr('style', 'display:inline');
//                            }
//                        }
                        
                                $("#saveButton").click(function() { 
                                    if (!$("#createClubForm").valid()) {
                                        return false;
                                    }
                                });

                        $("#clubDomainLabel").hide();
                        $("#clubDomainLabel2").hide();
                        // $('#saveButton').attr("disabled","disabled");
                        $("#clubDomain").blur(function() {
                            if ($('#clubDomain').attr("value") && $('#clubDomain').attr("value") != '')
                                $.get('<%=Url.Action("ValidateClubDomainName","ChannelClub") %>', { clubDomainName: $('#clubDomain').attr("value") }, function(data) {
                                    if (data.isSuccess) {
                                        $("#clubDomainLabel2").show();
                                        $("#clubDomainLabel").hide();
                                        $('#saveButton').removeAttr("disabled");
                                    }
                                    else {
                                        $("#clubDomainLabel").show();
                                        $("#clubDomainLabel2").hide();
                                    }
                                });
                        });
        
    </script>

</div>
