﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ForumSectionGroup>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }

    ForumSectionGroup forumGroup = ViewData.Model;
%>
<form class="nyroModal" id="editForumGroupForm" method="post" action="<%=Url.Action("CreateUpdateForumGroup", "ManageForum", new {groupID = forumGroup.GroupID})%>">
    <div class="tn-form tn-label-right">
            <div class="tn-text-heading tn-border-gray tn-border-bottom">
              <h4> <%if (forumGroup.GroupID > 0) { Response.Write("编辑版块组"); } else { Response.Write("添加版块组"); } %> </h4>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label"> 版块组名称：</label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="forumGroupName" id="forumGroupName" value="<%=forumGroup.GroupName %>"
                style="width: 194px;" />              
             </div>
          <%--  <div class="tn-form-row">
                <label class="tn-form-label"> 版块组简介：</label>
                 <textarea id="forumGroupBrief" name="forumGroupBrief" class="tn-textarea tn-input-text tn-input-long tn-border-gray" style=" height:100px;"><%=forumGroup.PostCount %></textarea>                                
             </div>--%>
           <%-- <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %></label>
                <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("forumGroupActive", forumGroup.IsPublic, new RouteValueDictionary { {"Class" , "radiobutton"} })%>
             </div>--%>
            <div class="tn-form-row">
                <label class="tn-form-label"> 排序序号：</label>
                 <input type="text" class="tn-textbox tn-input-short tn-border-gray" id="forumGroupDisplayOrder" name="forumGroupDisplayOrder"
                maxlength="256" value="<%=forumGroup.DisplayOrder %>"  />               
             </div>               
            <div class="tn-form-row tn-form-row-button">
             <label class="tn-form-label"> </label>
             <input type="submit" id="saveButton" name="saveButton" value="<%=GetResourceString("Button_Save") %>" />
            <input type="reset" class=" nyroModalClose" id="cancelButton" value="<%=GetResourceString("Button_Cancel") %>" />
         </div>
    </div>
</form>
<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#editForumGroupForm").validate({
            rules: {
                forumGroupName: { required: true,maxBlength:20},
                forumGroupDisplayOrder: { required: true,digits: true }
            },
            messages: {
                forumGroupName: { required: "请填写版块组名称",maxlenth:"版块组名称最长为20个字"},
                forumGroupDisplayOrder: {required:  "请填写序号", digits: "请输入数字" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#editForumGroupForm").valid()) {
                return false;
            }
        });
    });
</script>

