﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ForumSection>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    ForumSection section = ViewData.Model;
    int applicationID = ApplicationIDs.Instance().Forum();
    string action = Globals.GetFullUrlInFileHandlerSite(ForumSections.StorageProviderName, Url.Action("CreateUpdateForumSection", "ManageForum", new { sectionID = section.SectionID, parentID = ViewData.GetInt("parentID", 0), isChildSection = ViewData.GetBool("isChildSection", true) }));
%>
<form enctype="multipart/form-data" class="nyroModal" id="editSectionForm" method="post" action="<%=action%>">
<div class="tn-form tn-label-right">
    <div class="tn-text-heading tn-border-gray tn-border-bottom">
        <h4>
            <%if (section.SectionID > 0) { Response.Write("编辑版块"); } else { Response.Write("添加版块"); } %></h4>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            版块名称：</label>
        <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="forumSectionName"
            id="forumSectionName" value="<%=section.SectionName %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            标志图片<%=GetResourceString("Common_Colon")%></label>
        <input type="file" class="fileUpload" name="picfile" />
    </div>
    <%if (!string.IsNullOrEmpty(section.LogoUrl))
      { %>
    <div class="tn-form-row">
        <label class="tn-form-label">
        </label>
        <%                   
            Response.Write(string.Format("<img src=\"{0}\" width=\"110\" height=\"50\" /><br/>", SiteUrls.Instance().ForumSectionLogoUrl(section)));                  
        %>
    </div>
    <%} %>
    <div class="tn-form-row tn-textarea-wrap">
        <label class="tn-form-label">
            <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
        <textarea id="description" name="description" class="tn-textarea tn-input-text tn-input-long tn-border-gray"
            rows="4" cols="30"><%=section.Description %></textarea>
            <span style="display:none"></span>
    </div>
    <div class="tn-form-row tn-textarea-wrap">
        <label class="tn-form-label">
            版主：</label>
        <textarea id="ImmediateModeratorUserNames" name="ImmediateModeratorUserNames" class="tn-textarea tn-input-text tn-input-long tn-border-gray"
            rows="3" cols="30"><%if (section.ImmediateModeratorUserNames != null)
                                 {
                                     foreach (var userName in section.ImmediateModeratorUserNames)
                                     {
                                         Response.Write(userName + ",");
                                     }
                                 }%></textarea>
                                 <span style="display:none"></span>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            继承父版版主：</label>
        <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("inheriteModerator", section.InheriteModerator, new RouteValueDictionary { {"Class" , "radiobutton"}}) %>
    </div>
    <div class="tn-form-row tn-textarea-wrap">
        <label class="tn-form-label">
            版面规则：</label>
        <textarea id="rules" name="rules" class="tn-textarea tn-input-text tn-input-long tn-border-gray"
            rows="4" cols="30"><%=section.Rules %></textarea>
            <span style="display:none"></span>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            排序序号：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="displayOrder"
            name="displayOrder" maxlength="256" value="<%=section.DisplayOrder %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            是否允许匿名回帖：</label>
        <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("enableAnonymousPosting", section.EnableAnonymousPosting, new RouteValueDictionary { {"Class" , "radiobutton"} }) %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %></label>
        <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("isActive", section.IsActive, new RouteValueDictionary { {"Class" , "radiobutton"}}) %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            是否启用主题分类：</label>
        <%=SPBHtmlHelper.Instance().ShowRadioButtonList<int, string>("threadCategoryStatus", new Dictionary<int, string> { { (int)ThreadCategoryStatuses.Disabled, "禁用" }, { (int)ThreadCategoryStatuses.NotForceEnabled, "启用但不强制使用" }, { (int)ThreadCategoryStatuses.ForceEnabled, "启用并强制使用" } }, new RouteValueDictionary { { "class", "radiobutton" } }, (int)Model.ThreadCategoryStatus)%>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input type="submit"  id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
        <input type="reset" class="inputCancel nyroModalClose" id="cancelButton" value="<%=GetResourceString("Button_Cancel") %>" />
    </div>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $("#ImmediateModeratorUserNames").watermark("请输入版主的用户名,多个版主用逗号分开!");
        $("#editSectionForm").validate({
            rules: {
                forumSectionName: { required: true },
                displayOrder: { required: true, digits: true }
            },
            messages: {
                forumSectionName: { required: "必填" },
                displayOrder: { required: "请填写序号", digits: "请输入数字" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#editSectionForm").valid()) {
                return false;
            }
        });
    });
</script>