﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ForumThreadCategory>" %>
<%
    if (TempData["StatusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData");
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',3000);</script>"));
        }
        TempData["StatusMessageData"] = null;
    }
%>
<form class="nyroModal" id="editSectionForm" method="post" action="<%=Url.Action("CreateUpdateForumThreadCategory", "ManageForum", new {categoryID=Model.CategoryID, sectionID=Model.SectionID })%>">
  <div class="tn-form tn-label-right">
     <div class="tn-text-heading tn-border-gray tn-border-bottom">
     <h4><%if (Model.CategoryID > 0) { Response.Write("编辑主题分类"); } else { Response.Write("添加主题分类"); } %></h4> 
   </div>
     <div class="tn-form-row">
                <label class="tn-form-label">  主题分类名称：</label>
               <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="categoryName" id="categoryName"
                value="<%=Model.CategoryName %>" /><span class="tn-form-required"> </span>             
      </div>
     <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
              <textarea id="categoryDescription" name="categoryDescription" class="tn-textarea tn-input-text tn-input-long tn-border-gray"
                rows="4" cols="30"><%=Model.CategoryDescription %></textarea><span class="tn-form-required">
                </span>         
      </div>
     <div class="tn-form-row">
                <label class="tn-form-label">   排序序号：</label>
               <input  class="tn-textbox tn-input-short tn-border-gray" style="width: 50px" id="displayOrder" name="displayOrder"
                maxlength="256" value="<%=Model.DisplayOrder %>" />          
      </div>
     <div class="tn-form-row tn-form-row-button">
             <label class="tn-form-label"> </label>
            <input type="submit"  id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
            <input type="reset" class="inputCancel nyroModalClose" id="cancelButton" value="<%=GetResourceString("Button_Cancel") %>" />
       </div>
</div>
</form>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#editSectionForm").validate({
            rules: {
            categoryName: { required: true, maxBlength: 8 },
            categoryDescription: { maxBlength: 100 },
            displayOrder: { required: true, digits: true }
            },
            messages: {
            categoryName: { required: "必填", maxBlength: "分类名称最长允许8个字" },
            categoryDescription: { maxBlength: "分类名称最长允许100个字" },
            displayOrder: { required: "请填写序号", digits: "请输入数字" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#editSectionForm").valid()) {
                return false;
            }
        });
    });
</script>

