﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Dictionary<ForumSectionGroup, List<ForumSection>>>" %>
 
   <div class="tn-list-header">
       <div class="tn-toolbar-area tn-helper-clearfix">
                    <%=SPBHtmlHelper.Instance().LinkButton("addSectionGroup", "添加版块组", Url.Action("Control_EditForumGroup", "ManageForum"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary { { "class", "iconLink icoLinkAdd" } }, null)%>                 
       </div>
   </div>   
<table class="tn-table-grid" >
    <tr class="tn-table-grid-header">
        <th  class="tn-border-gray tn-border-bottom tn-text-note">
            版块名称
        </th>
        <th  class="tn-border-gray tn-border-bottom tn-text-note">
            排列序号
        </th>
        <th  class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_IsEnabled")%>
        </th>
        <th  class="tn-border-gray tn-border-bottom tn-text-note">
            版主
        </th>
        <th  class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_Actions")%>
        </th>
    </tr>
    <%if (ViewData.Model.Count > 0)
      {
        
          foreach (var dict in ViewData.Model)
          {%>
    <tr class="tn-table-grid-row">     
        <%ForumSectionGroup group = dict.Key;%>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <h5>
                <a target="_blank" href="<%=SiteUrls.Instance().ShowForumGroup(group.GroupID) %>">
                    <%=group.GroupName%></a></h5>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <%=group.DisplayOrder %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">          
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">                           
           <span class="tn-action"><a  name="updateButton" href="<%=SPBUrlHelper.Action("Control_EditForumGroup", "ManageForum", new RouteValueDictionary {{"groupID",group.GroupID}})%>"
                class="tn-action-text submit editSectionModal">编辑</a></span> 
           <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"  menu="#g-moreOptions<%=group.GroupID %>"> 
           <span class="tn-icon tn-icon-triangle-down"></span> <a  name="addSection" id="addSection" href="<%=Url.Action("Control_EditForumSection", "ManageForum", new { parentID=group.GroupID,isChildSection=false })%>"
                        class="tn-action-text submit AddSectionModal">添加版块</a> </span>
              <div id="g-moreOptions<%=group.GroupID %>" class="tn-drop-menu ui-widget-content" style="display:none;">
                <ul class="tn-menu-drop-list">
                  <li class="tn-menu-drop-item">           
                      <a id="ConvertForumToClub" class="ConvertForumToClub submit"
                            title="将此版块组转换为群组" href="<%=Url.Action("Control_ConvertForumGroupToClub", "ManageForum", new { groupID = group.GroupID })%>">
                            转换为群组</a>                           
                  </li>
                  <li class="tn-menu-drop-item">
                    <a href="javascript:;"   onclick="if (confirm('点击确定将直接删除子版块和帖子，需要保留子版块和帖子请点击取消执行合并或移动操作，确定删除吗？')) { $('#ListForumSectionsForLoad').load('<%=SPBUrlHelper.Action("DeleteForumGroup", "ManageForum", new RouteValueDictionary { { "groupID", group.GroupID } })%>')}" >删除</a>                 
                  </li>
                </ul>
              </div>
        </td>
    </tr>
    <% 
        List<ForumSection> sections = dict.Value;
        if (sections != null && sections.Count > 0)
        {
            foreach (ForumSection currentSection in sections)
            { 
    %>
    <tr class="tn-table-grid-row">       
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <% for (int i = 0; i < currentSection.Depth + 1; i++)
               {
                   Response.Write(" &nbsp; &nbsp; &nbsp; &nbsp; ");
               } %>
            <a target="_blank" href="<%=SiteUrls.Instance().ShowForumSection(currentSection.SectionID) %>">
                <%=currentSection.SectionName%></a>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <%=currentSection.DisplayOrder%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <%if (currentSection.IsActive)
              { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
              else
              { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <%if (currentSection.ImmediateModeratorDisplayNames != null)
              {
                  foreach (var displayName in currentSection.ImmediateModeratorDisplayNames)
                  {
                      Response.Write(displayName + ",");
                  }
              }
            %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">       
           <span class="tn-action">  <a name="updateButton" href="<%=Url.Action("Control_EditForumSection", "ManageForum", new { sectionID=currentSection.SectionID })%>"
                class="tn-action-text submit editSectionModal">编辑</a></span> 
           <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"  menu="#s-moreOptions<%=currentSection.SectionID %>"> 
           <span class="tn-icon tn-icon-triangle-down"></span><a href="<%=Url.Action("Control_EditForumSection", "ManageForum", new { parentID=currentSection.SectionID,isChildSection=true })%>"
                        class="tn-action-text submit AddSectionModal">添加子版块</a>  </span>
              <div id="s-moreOptions<%=currentSection.SectionID %>" class="tn-drop-menu ui-widget-content" style="display:none;">
                <ul class="tn-menu-drop-list">                  
                  <li class="tn-menu-drop-item">  <a title="将该版块下的所有子版块和帖子<%=GetResourceString("Enum_AccountStatuses_All")%>移到目标版块下，同时删除该版块"
                            class="submit sectionModal" href="<%=this.Url.Action("Control_MergeOrMoveSection", "ManageForum", new {isMerge=true, FilterID =currentSection.SectionID})%>">
                            合并</a></li>
                   <li class="tn-menu-drop-item"> <a title="将该版块移动到目标版块下，作为目标版块的子版块，该版块下的帖子仍然保留" class="submit sectionModal"
                                href="<%=this.Url.Action("Control_MergeOrMoveSection", "ManageForum", new {isMerge=false, FilterID =currentSection.SectionID})%>">
                                转移</a></li>
                    <li class="tn-menu-drop-item"> <a  title="管理主题分类" href="<%=SPBUrlHelper.Action("ManageForumThreadCategories","ManageForum",new RouteValueDictionary{{"SectionID",currentSection.SectionID}}) %>">
                                    主题分类</a></li>
                    <li class="tn-menu-drop-item">
                      <a href="javascript:;" onclick="if (confirm('确定要删除版块和帖子吗？')) { $('#ListForumSectionsForLoad').load('<%=this.Url.Action("DeleteForumSection", "ManageForum", new { sectionID = currentSection.SectionID })%>')}" >删除</a>
                    </li>
                  
                </ul>
              </div>
        </td>
    </tr>
    <%
        }
        }
          }
      }
    %>
</table>
<br /><br />
<script type="text/javascript">
    $(document).ready(function() {
        $('#addSectionGroup,.sectionModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 300,
            endRemove: function(elts, settings) {
                $('#ListForumSectionsForLoad').load('<%=this.Url.Action("Control_ListForumSections","ManageForum")%>');
            }
        });
    });

    $(document).ready(function() {
        $('.editSectionModal,.AddSectionModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 500,
            endRemove: function(elts, settings) {
                $('#ListForumSectionsForLoad').load('<%=this.Url.Action("Control_ListForumSections","ManageForum")%>');
            }
        });
    });

    $(document).ready(function() {
        $('.ConvertForumToClub').nyroModal({
            resizeable: true,
            width: 720,
            height: 500,
            endRemove: function(elts, settings) {
                $('#ListForumSectionsForLoad').load('<%=this.Url.Action("Control_ListForumSections","ManageForum")%>');
            }
        });
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
      
    }); 

</script>

