﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ApplicationTag>>" %>
<% int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
   string keyWords = ViewData.GetString("keyWords", string.Empty);
%>
<div id="tagForLoad">
    <form id="ManageTagsForm" action="<%=SPBUrlHelper.Action("Control_ListTags", "ManageForum")%>"
    method="post">
    <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
            <tr>
                <th>
                    关键字：
                </th>
                <td>
                    <input name="keyWords" type="text" class="tn-textbox tn-input-medium tn-border-gray"
                        id="keyWords" value="<%=keyWords %>" />
                </td>
                <td>
                    <input type="submit" value="<%=GetResourceString("Button_Search") %>" class="tn-botton" />
                </td>
            </tr>
        </table>
    </div>
    <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
            <%=SPBHtmlHelper.Instance().LinkButton("newTagModal", "增加新标签", Url.Action("Control_EditTag", "ManageForum"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText,null, null)%>
            <%=SPBHtmlHelper.Instance().LinkButton("del", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                                                                                                                        new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些标签吗？')) { $('#ManageTagsForm').attr('action','" + SPBUrlHelper.Action("DeleteTags", "ManageForum", new RouteValueDictionary { { "pageIndex", pageIndex } }) + "');$('#ManageTagsForm').submit(); return false; } else {  return false; };" }, { "title", "删除选中的标签" } }, null)%>
        </div>
    </div>
    <%if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      }%>
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom">
                <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'LinkGroup')" />
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                标签名称
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                内容数量
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                作者
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_UpdateDate")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                操作
            </th>
        </tr>
        <%
            foreach (var tag in Model.Records)
            {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <input type="checkbox" class="tn-checkbox" name="LinkGroup" value="<%=tag.TagName%>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=tag.TagName %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=tag.ItemCount %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=tag.Author %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=Formatter.FormatDate(tag.LastModified)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                <a href="javascript:;" onclick="if (confirm('确定要删除该标签吗？')) { $('#tagForLoad').load('<%=this.Url.Action("DeleteTag","ManageForum",new {tagName=WebUtils.UrlEncode(tag.TagName),pageIndex = Model.PageIndex }) %>' )}">
                    删除</a>
            </td>
        </tr>
        <%}%>
    </table>
    <%if (Model.TotalRecords > Model.PageSize)
      {%>
    <div class="tn-pagination tn-helper-align-center">
        <%= SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListTags", "ManageForum", new RouteValueDictionary { { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
    <%}%>

    <script type="text/javascript">
        function pageIndexChange(url) {
            $('#tagForLoad').load(url);
        }
        $(document).ready(function() {
        
         $('#ManageTagsForm').ajaxForm({
            beforeSubmit: function() {
            if (!$("#ManageTagsForm").valid())
                { return false; }
            },
            target: '#tagForLoad'
        });
        
            $('.tn-table-grid-row').hover(function() {
                $(this).addClass('tn-bg-gray');
            }, function() {
                $(this).removeClass('tn-bg-gray');
            });
            $('#newTagModal').nyroModal({
                resizeable: true,
                width: 300,
                height: 300,
                endRemove: function(elts, settings) {
                    $('#tagForLoad').load('<%=this.Url.Action("Control_ListTags", "ManageForum")%>');
                }
            });
        });
    </script>

    </form>
</div>
