﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Dictionary<SpaceBuilder.Club.Club, List<ForumSection>>>" %>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
        }
        else
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        }
        TempData["StatusMessageType"]=null;
    }   
%>
<%if (ViewData["fromSection"] != null)
  {
      bool isMerge = ViewData.GetBool("isMerge", true);
      ForumSection fromSection = ViewData["fromSection"] as ForumSection;%>
<form id="editor" action="<%=this.Url.Action("MergeOrMoveSection", "ManageForum", new {isMerge=isMerge,fromSectionID=fromSection.SectionID })%>"
   method="post" class="nyroModal">
 <div class="tn-form tn-label-right">
     <div class="tn-text-heading tn-border-gray tn-border-bottom">
     <h4> <%if (isMerge) Response.Write("合并"); else { Response.Write("转移"); } %></h4> 
   </div>
     <div class="tn-form-row">
                <label class="tn-form-label">  当前版块：</label>
                <input type="text" class="textBox" maxlength="256" id="title" name="title" disabled="disabled"
                        value="<%=fromSection.SectionName %>" />
                    <span class="tn-form-required"></span>               
      </div>
     <div class="tn-form-row">
                <label class="tn-form-label"> 请选择目标版块：</label>
                 <%if (isMerge)
                      {
                          Response.Write(SPBHtmlHelper.Instance().ForumSectionsDropDownList("sectionDDL", null, fromSection.SectionID, string.Empty, false, " --请 选 择-- ", new RouteValueDictionary { {"Class","dropDownList" }}));
                      }
                      else
                      {
                          Response.Write(SPBHtmlHelper.Instance().ForumSectionsDropDownList("sectionDDL", null, fromSection.SectionID, string.Empty, true, " --请 选 择-- ", new RouteValueDictionary { { "Class", "dropDownList" } }));
                      } %>            
      </div>
     <div class="tn-form-row tn-form-row-button">
             <label class="tn-form-label"> </label>
              <input type="submit" value="<%=GetResourceString("Button_Save") %>" id="SaveButton"  />
              <input type="button" value="<%=GetResourceString("Button_Cancel") %>" class="inputCancel nyroModalClose" />
       </div> 
</div>
</form>
<%} %>

<script type="text/javascript" rel="forceLoad">
    <!--
        $(document).ready(function() {
            $("#editor").validate({
                rules: {
                    sectionDDL: "required"
                },
                messages: {
                    sectionDDL: "请选择版块"
                }
            });

            $("#SaveButton").click(function() {
                if (!$("#editor").valid()) {
                    return false;
                }
            });
        }); 
   //--> 
</script>

