﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<SiteCategory>>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        TempData["StatusMessageType"] = null;
    }
    int applicationID = ViewData.GetInt("ApplicationID", 0);
    int depth = ViewData.GetInt("Depth", 1);
    Dictionary<string, Language> languages = Languages.GetLanguages(false); 
%>
<div id="ListSiteCategories">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                类别名称
            </th>
            <% foreach (Language language in languages.Values)
               { %>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                类别<%=language.NativeName%>名称
            </th>
            <%} %>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                排列序号
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                内容数量
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                操作
            </th>
        </tr>
        <%foreach (SiteCategory category in ViewData.Model)
          { %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <% for (int i = 0; i < category.Depth; i++)
                   {
                       Response.Write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                   } %>
                <%=category.CategoryName %>
            </td>
            <% foreach (string languageCode in languages.Keys)
               { %>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <% if (category.CategoryNameRes != null && category.CategoryNameRes.ContainsKey(languageCode)) Response.Write(category.CategoryNameRes[languageCode]); else Response.Write("未填"); %>
            </td>
            <%} %>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=category.DisplayOrder %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=category.ItemCount %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                <span class="tn-action"><a class="siteCategoryModal tn-action-text" name="updateButton"
                    href="<%=Url.Action("Control_EditSiteCategory", "Manage",new{applicationID=applicationID,depth=depth, categoryID=category.CategoryID })%>">
                    编辑</a> </span><span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                        menu="#moreOptions3<%=category.CategoryID %>"><span class="tn-icon tn-icon-triangle-down">
                        </span><a class="tn-action-text" href="javascript:;" onclick="if (confirm('确认要删除这个站点类别吗？')) $('#ListSiteCategories').parent().load('<%=Url.Action("DeleteSiteCategory", "Manage", new {applicationID=applicationID,depth=depth, categoryID=category.CategoryID })%>');"
                            >删除</a></span>
                <div id="moreOptions3<%=category.CategoryID %>" class="tn-drop-menu ui-widget-content"
                    style="display: none;">
                    <ul class="tn-menu-drop-list">
                        <% if (category.Depth < depth)
                           { %>
                        <li class="tn-menu-drop-item"><a name="createClildCategory" href="<%=Url.Action("Control_EditSiteCategory", "Manage",new{applicationID=applicationID,parentID=category.CategoryID})%>"
                            class="siteCategoryModal">添加子类别</a></li>
                        <%} %>
                        <li class="tn-menu-drop-item"><a title="将该类别下的所有子类别及内容项<%=GetResourceString("Enum_AccountStatuses_All")%>移到目标类别下，同时删除该类别" class="siteCategoryModal"
                            href="<%=this.Url.Action("Control_MergeOrMoveSiteCategory", "Manage", new {applicationID=applicationID,isMerge=true, FilterID =category.CategoryID})%>">
                            合并</a> </li>
                        <li class="tn-menu-drop-item"><a title="将该类别移动到目标类别下，作为目标类别的子类别" class="siteCategoryModal"
                            href="<%=this.Url.Action("Control_MergeOrMoveSiteCategory", "Manage", new {applicationID=applicationID,isMerge=false, FilterID =category.CategoryID})%>">
                            转移</a> </li>
                    </ul>
                </div>
            </td>
        </tr>
        <%}  %>
    </table>
<br /><br /><br /><br />
    <script type="text/javascript">
        $(document).ready(function() {
            $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
            $('a.siteCategoryModal').nyroModal({
                resizeable: true,
                width: 300,
                height: 300,
                endRemove: function(elts, settings) {
                    $('#ListSiteCategories').parent().load('<%=Url.Action("Control_ManageSiteCategories", "Manage",new{applicationID=applicationID,depth=depth})%>');
                }
            });
        }); 
    </script>

</div>
