﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<SiteTag>>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        TempData["StatusMessageType"] = null;
    }
    string userTagIteamkey = ViewData.GetString("userTagIteamkey");
    string keyWords = TempData.GetString("KeyWords");
%>
<div id="siteTagMain">
    <form id="ManageSearchForm" action="<%=SPBUrlHelper.Action("SearcheSiteTags", "Manage", new RouteValueDictionary{ {"userTagIteamkey",userTagIteamkey}})%>"
    method="post">
    <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
            <tr>
                <th>
                    关键字：
                </th>
                <td>
                    <input name="userTagIteamkey" type="hidden" value="<%=userTagIteamkey %>" />
                    <input name="KeyWords" type="text" class="tn-textbox tn-input-medium tn-border-gray"
                        id="KeyWords" value="<%=keyWords %>" />
                </td>
                <td>
                    <input type="submit" value="<%=GetResourceString("Button_Search") %>" class="tn-botton" />
                </td>
            </tr>
        </table>
    </div>
    <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
            <%=SPBHtmlHelper.Instance().LinkButton("del", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                    new RouteValueDictionary {  { "title", "删除选中的标签" } }, null)%>
        </div>
    </div>
    <div id="ListSiteCategories">
        <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom">
                    <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    站点标签签名
                </th>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    内容数
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    用户数
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    最后更新日期
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    操作
                </td>
            </tr>
            <%
                foreach (SiteTag siteTag in ViewData.Model.Records)
                { %>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" name="CheckBoxGroup" class="tn-checkbox" value="<%=siteTag.TagName %>" />
                </td>
                <th class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=siteTag.TagName %>
                </th>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=siteTag.ItemCount%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=siteTag.UserCount%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <%=Formatter.FormatDate(siteTag.LastModified) %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                    <span class="tn-action"><a href="javascript:;" onclick="if (confirm('确认要删除当前标签？')){ DeleteSitetag('<%=SPBUrlHelper.Action("DeleteSiteTag", "Manage", new RouteValueDictionary { { "userTagIteamkey", userTagIteamkey },{"tageName",WebUtils.UrlEncode(siteTag.TagName)},{"keyWords",keyWords}})%>');}">
                        删除</a> </span>
                </td>
            </tr>
            <%}  %>
        </table>
        <%if (Model.TotalRecords > Model.PageSize)
          {%>
        <div class="tn-pagination tn-helper-align-center">
            <%= SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ManageSiteTags", "Manage", new RouteValueDictionary { { "userTagIteamkey", userTagIteamkey },{ "pageIndex", "{0}" } }), "pageIndexChange")%>
            <div class="tn-page-results tn-text-note">
                <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
        </div>
        <%}%>

        <script type="text/javascript">

            $("#del").click(function() {
                if ($("input[name='CheckBoxGroup']:checked").length <= 0) {
                    alert("至少选择一个标签！");
                    return false;
                }
                if (confirm('确认要删除这些标签吗？')) { $('#ManageSearchForm').attr('action', '<%=SPBUrlHelper.Action("DeleteSiteTags", "Manage", new RouteValueDictionary { { "userTagIteamkey", userTagIteamkey },{"keyWords",keyWords}})%>'); $('#ManageSearchForm').submit(); return false; } else { return false; };
            });




            function pageIndexChange(url) {
                $('#siteTagMain').load(url);
            }

            function DeleteSitetag(url) {
                $('#siteTagMain').load(url);
            }
            $(document).ready(function() {
                $('#ManageSearchForm').ajaxForm({
                    beforeSubmit: function() {
                        if (!$("#ManageSearchForm").valid())
                        { return false; }
                    },
                    target: '#siteTagMain'
                });
                $('.tn-table-grid-row').hover(function() {
                    $(this).addClass('tn-bg-gray');
                }, function() {
                    $(this).removeClass('tn-bg-gray');
                });
            });
        
        </script>

    </div>
    </form>
</div>
