﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<SpaceBuilder.Common.PersonUser>" %>
<%

    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',3000);refresh();</script>"));
        }
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        TempData["StatusMessageType"] = null;
    }

    if (ViewData.Model != null)
    {
        PersonUser u = ViewData.Model as PersonUser;
        if (u != null)
        { 
%>
<form action="<%=Url.Action("DeleteUser", "ManageUser", new { UserID = u.UserID })%>"
method="post" class="tn-helper-reset nyroModal">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        删除用户</h4>
    <div class="tn-form-row">
        请选择删除的方式</div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            用户名：</label>
        <%=u.UserName %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            删除方式：</label>
        <input id="isReassign1" class="tn-radiobutton" name="isReassign" type="radio" checked
            value="false" onclick="$('#reassign').css('display','none');" /><label for="isReassign1">删除用户及其相关信息</label>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
        </label>
        <input name="isReassign" class="tn-radiobutton" id="isReassign2" type="radio" value="true"
            onclick="$('#reassign').css('display','');" /><label for="isReassign2">删除用户，但将其相关信息转让给其他用户</label>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            接收转让的用户名：</label>
        <input type="text" name="reassignUserName" class="tn-textbox tn-input-medium tn-border-gray" />
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Large, new RouteValueDictionary { { "onclick", "if ( !confirm('您真的要删除该用户吗？') ) { return false; }" } }, null)%>
        <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
    </div>
</div>
</form>
<%       
    }
    }
        
%>