﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Identity>" %>
<%

        if (TempData["statusMessageData"] != null)
        {
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
            if (statusMessageData.MessageType == StatusMessageType.Success)
            {
                //关闭模式窗口
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["statusMessageData"] = null;
        }
   
    
    %>

<form id="EditIdentityForm" name="EditIdentityForm" method="post" action="<%=Url.Action("CreateUpdateIdentity", "ManageUser", new RouteValueDictionary { { "identityID",Model.IdentityID } }) %>"
class="tn-helper-reset nyroModal" enctype="multipart/form-data">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=Model.IdentityID>0?"修改认证":"认证标识" %> </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> 认证标识名称</label>
      <input class="tn-textbox tn-input-long tn-border-gray" type="text" value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.Name) %>"
            id="IdentityName" name="IdentityName" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 小标识图片：</label>
      <input class="tn-textbox tn-input-long tn-border-gray" type="file" id="SmallIconFileName"
            name="SmallIconFileName" />
    </div>
    <div class="tn-text-note"> 标识图片为16*16像素，支持JPG、GIF、BMP 或 PNG </div>
    <% if (Model.IdentityID > 0)
       {%>
    <div class="tn-form-row">
      <label class="tn-form-label"> 预览：</label>
      <img src="<%=SiteUrls.Instance().IdentityIcon(Model, IdentityIconTypes.Small) %>" /> </div>
    <%} %>
    <div class="tn-form-row">
      <label class="tn-form-label"> 大标识图片：</label>
      <input class="tn-textbox tn-input-long tn-border-gray" type="file" id="BigIconFileName"
            name="BigIconFileName" />
    </div>
    <div class="tn-text-note"> 标识图片为103*27像素，支持JPG、GIF、BMP 或 PNG </div>
    <%  if (Model.IdentityID > 0)
        {%>
    <div class="tn-form-row">
      <label class="tn-form-label"> 预览：</label>
      <img src="<%=SiteUrls.Instance().IdentityIcon(Model, IdentityIconTypes.Big) %>" /> </div>
    <%} %>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> 描述:</label>
      <textarea class="tn-textarea tn-input-long tn-border-gray" id="Description" name="Description"><%=Formatter.FormatMultiLinePlainTextForEdit(Model.Description,true) %></textarea>
      <span style="display:none"></span>
    </div>
<div class="tn-form-row tn-form-row-button">
    <label class="tn-form-label"></label>
    <%=SPBHtmlHelper.Instance().SubmitButton("editoIdentityButton",Model.IdentityID>0?"修改":"创建", ButtonSizes.Default,null,null) %> <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } }, null)%> </div>  
  </div>
  
</form>
<script type="text/javascript" rel="forceLoad">
    $(document).ready(function () {
        $("#EditIdentityForm").validate({
            rules: {
                IdentityName: { required: true, maxBlength: 8 },
                Description: { required: true, maxBlength: 512 }
            },
            messages: {
                IdentityName: { required: "身份标识名称不能为空", maxBlength: "身份标识名称不能超过8个字" },
                Description: { required: "请输入用户身份标识描述", maxBlength: "描述不能超过512个字" }
            }

        });
        $("#editoIdentityButton").click(function () {
            if (!$("#EditIdentityForm").valid()) {
                return false;
            }
        });

    });
</script>
