﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<SpaceBuilder.Common.PersonUser>" %>
<%

    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();',3000);refresh();</script>"));
        }
        TempData["StatusMessageType"] = null;
    }

    if (ViewData.Model != null)
    {
        PersonUser u = ViewData.Model as PersonUser;
        if (u != null)
        { 
        
%>

<form id="EditUserInfo" action="<%=Url.Action("Control_UpdateUserInfo", "ManageUser", new { UserID = u.UserID })%>" method="post" class="nyroModal">
  <div class="tn-form tn-label-right spb-modify-user-info">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">修改用户资料</h4>
    <div class="tn-text-subheading"> 请修改以下详细信息</div>
    <div class="tn-form-row">
      <label class="tn-form-label">用户名：</label>
      <%=u.UserName %> </div>
    <div class="tn-form-row">
      <label class="tn-form-label">用户ID：</label>
      <%=u.UserID %> </div>
    <div class="tn-form-row">
      <label class="tn-form-label">密码存储为：</label>
      <%=u.PasswordFormat.ToString() %> </div>
      <div class="tn-form-row">
      <label class="tn-form-label">电子邮箱：</label>
      <input id="PublicEmail" class="tn-textbox tn-input-medium tn-border-gray" type="text" name="PublicEmail" value="<%=u.PublicEmail%>" />
      </div>
    <div class="tn-form-row">
      <label class="tn-form-label">头像审批：</label>
      <input id="EnableAvatar" class="tn-radiobutton" name="EnableAvatar" type="radio"
            <% if(u.EnableAvatar){ Response.Write("Checked"); } %> value="true" />
      是&nbsp;
      <input name="EnableAvatar" class="tn-radiobutton" id="EnableAvatar" type="radio" <% if(!u.EnableAvatar){ Response.Write("Checked"); } %>
                value="false" />
      否 </div>
    <div class="tn-form-row">
      <label class="tn-form-label">会员列表显示：</label>
      <input id="InMember" name="InMember" type="radio" class="tn-radiobutton" <% if(u.EnableDisplayInMemberList){ Response.Write("Checked"); } %>
            value="true" />
      是&nbsp;
      <input name="InMember" class="tn-radiobutton" id="InMember1"
                type="radio" <% if(!u.EnableDisplayInMemberList){ Response.Write("Checked"); } %>
                value="false" />
      否 </div>
    <div class="tn-form-row">
      <label class="tn-form-label">是否显示头像：</label>
      <input id="Radio3" class="tn-radiobutton" name="IsAvatarApproved" type="radio"
            <% if(u.IsAvatarApproved){ Response.Write("Checked"); } %> value="true" />
      是&nbsp;
      <input
                name="IsAvatarApproved" class="tn-radiobutton" id="Radio4" type="radio" <% if(!u.IsAvatarApproved){ Response.Write("Checked"); } %>
                value="false" />
      否 </div>
    <div class="tn-form-row">
      <label class="tn-form-label">是否管制：</label>
      <input id="Radio1" class="tn-radiobutton" name="IsModerated" type="radio"
            <% if(u.IsModerated){ Response.Write("Checked"); } %> value="true"  />
      是&nbsp;
      <input
                name="IsModerated" class="tn-radiobutton" id="Radio2" type="radio" <% if(!u.IsModerated){ Response.Write("Checked"); } %>
                value="false"  />
      否 </div>
    
      <div class="tn-form-row">
        <label class="tn-form-label">账号状态：</label>
        <select class="tn-dropdownlist" name="UserStatus" onchange="cai(this.value)">
          <option onclick="$('#ManageState').css({'visibility':'hidden'});" value="<%=(int)UserAccountStatuses.Approved%>" <%if (UserAccountStatuses.Approved == u.AccountStatus) { Response.Write("selected"); } %>> 已批准</option>
          <option onclick="$('#ManageState').css({'visibility':'hidden'});" value="<%=(int)UserAccountStatuses.ApprovalPending%>" <%if (UserAccountStatuses.ApprovalPending == u.AccountStatus) { Response.Write("selected"); } %>> 待批准</option>
          <option onclick="$('#ManageState').css({'visibility':'visible'});" value="<%=(int)UserAccountStatuses.Banned%>" <%if (UserAccountStatuses.Banned == u.AccountStatus) { Response.Write("selected"); } %>> 封禁中</option>
          <option onclick="$('#ManageState').css({'visibility':'hidden'});" value="<%=(int)UserAccountStatuses.Disapproved%>" <%if (UserAccountStatuses.Disapproved == u.AccountStatus) { Response.Write("selected"); } %>> 未批准</option>
        </select>
      </div>
<div id="ManageState" class="spb-controlled" style="visibility:hidden">
      <div class="tn-form-row">
        <label class="tn-form-label">封禁原因：</label>
        <select name="UserBanReasons" class="tn-dropdownlist">
          <option value="<%=(int) UserBanReasons.Profanity %>" <% if(u.BanReason == UserBanReasons.Profanity) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_Profanity")%></option>
          <option value="<%=(int) UserBanReasons.Advertising %>" <% if(u.BanReason == UserBanReasons.Advertising) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_Advertising") %></option>
          <option value="<%=(int) UserBanReasons.Spam %>" <% if(u.BanReason == UserBanReasons.Spam) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_Spam")%></option>
          <option value="<%=(int) UserBanReasons.Aggresive %>" <% if(u.BanReason == UserBanReasons.Aggresive) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_Aggresive") %></option>
          <option value="<%=(int) UserBanReasons.BadUsername %>" <% if(u.BanReason == UserBanReasons.BadUsername) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_BadUsername")%></option>
          <option value="<%=(int) UserBanReasons.BadSignature %>" <% if(u.BanReason == UserBanReasons.BadSignature) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_BadSignature")%></option>
          <option value="<%=(int) UserBanReasons.BanDodging %>" <% if(u.BanReason == UserBanReasons.BanDodging) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_BanDodging")%></option>
          <option value="<%=(int) UserBanReasons.Other %>" <% if(u.BanReason == UserBanReasons.Other) { Response.Write("selected"); }%>> <%=GetResourceString("Utility_UserBanReason_Other") %></option>
        </select>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label">封禁到：</label>
        <%
            if (UserAccountStatuses.Banned == u.AccountStatus)
                Response.Write(Formatter.FormatFriendlyDate(u.BannedUntil));
            else
                Response.Write("未设置");
        %>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label">
          <%
                                         if (UserAccountStatuses.Banned == u.AccountStatus)
                                             Response.Write("重设封禁天数：");
                                         else
                                             Response.Write("封禁天数：");
                %>
        </label>
        <select name="UserBanTime" class="tn-dropdownlist">
          <option value=""></option>
          <option value="<%=(int) UserBanPeriods.Permanent%>"> <%=GetResourceString("Utility_UserBan_Permanent")%> </option>
          <option value="<%=(int) UserBanPeriods.OneDay%>"> <%=GetResourceString("Utility_UserBan_1Day")%></option>
          <option value="<%=(int) UserBanPeriods.ThreeDays%>"> <%=GetResourceString("Utility_UserBan_3Days")%></option>
          <option value="<%=(int) UserBanPeriods.FiveDays%>"> <%=GetResourceString("Utility_UserBan_5Days")%></option>
          <option value="<%=(int) UserBanPeriods.OneWeek%>"> <%=GetResourceString("Utility_UserBan_1Week")%></option>
          <option value="<%=(int) UserBanPeriods.TwoWeeks%>"> <%=GetResourceString("Utility_UserBan_2Weeks")%></option>
          <option value="<%=(int) UserBanPeriods.OneMonth%>"> <%=GetResourceString("Utility_UserBan_1Month")%></option>
        </select>
      </div>
    </div>
    <div class="tn-form-row tn-form-row-button"><label class="tn-form-label"></label>
      <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default,null, null)%> 
	  <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%> </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#UserStatus').change();
            $('#ManageState').change();

$("#EditUserInfo").validate({
    rules: {
        PublicEmail: { email: true }
    },
    messages: {
        PublicEmail: { email: "请输入正确的email地址" }

    }

});
            
        });
        function cai(a) {
            if (a == '2') {
                $('#fengjin').css('display', '');
                $('#fengjin2').css('display', '');
                $('#fengjin3').css('display', '');
            }
            else {
                $('#fengjin').css('display', 'none');
                $('#fengjin2').css('display', 'none');
                $('#fengjin3').css('display', 'none');
            }
        }
    </script>
  </div>
</form>
<%
    if (UserAccountStatuses.Banned == u.AccountStatus)
    {
        Response.Write("<script type=\"text/javascript\">$('#fengjin').css('display','');$('#fengjin2').css('display','');$('#fengjin3').css('display','');</script>");
    }
        }
    }
%>
