﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<UserIdentity>" %>
<% int UserID = Html.GetParameterFromRouteDateOrQueryString<int>("UserID");  %>
<%

    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["statusMessageData"] = null;
    }   
%>

<form name="EditUserIdentityForm" id="EditUserIdentityForm" method="post" action="<%=Url.Action("CreateUpdateUserIdentity", "ManageUser", new RouteValueDictionary { { "UserID",UserID } })%>"
class="tn-helper-reset nyroModal">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=Model.IdentityID>0? "修改认证":"认证标识" %> </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> 选择身份：</label>
      <select class="tn-dropdownlist" name="identityID">
        <% if (Model != null)
               {
                   Dictionary<int, Identity> userIdentity = ViewData["AllIdentities"] as Dictionary<int, Identity>;
                   if (userIdentity != null && userIdentity.Count > 0)
                   {
                       foreach (var item in userIdentity)
                       {%>
        <% if (item.Value != null)
                          { %>
        <option value="<%=item.Value.IdentityID %>" <% if (Model.IdentityID == item.Value.IdentityID) Response.Write("selected='selected' "); %>   > <%=item.Value.Name%> </option>
        <%} %>
        <%  }
                   }
               } 
            %>
      </select>
    </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> 描述：</label>
      <textarea class="tn-textarea tn-input-long tn-border-gray" rows="" id="Description"
            name="Description"><%=Formatter.FormatMultiLinePlainTextForEdit(Model.IdentityDescription ,true) %></textarea><span style="display:none"></span>
      <div class="tn-text-note"> 请用简短的语句描述下用户的身份，不允许超过256个字</div>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("editoIdentityButton", Model.IdentityID > 0 ? "修改" : "创建", ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } }, null)%> </div>
  </div>
</form>
<script type="text/javascript" rel="forceLoad">
    $(document).ready(function () {
        $("#editoIdentityButton").click(function () {
            if (!$("#EditUserIdentityForm").valid()) {
                return false;
            }
        });

            $("#EditUserIdentityForm").validate({            
                rules: {
                    Description: { required: true, maxBlength: 256 }
                },
                messages: {
                    Description: { required: "请输入用户身份标识描述", maxBlength: "描述不能超过256个字" }
                }

            });
        
    });
</script>
