﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Role>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout(' $.nyroModalRemove();refresh(); ',3000); </script>"));
        }
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        TempData["StatusMessageType"] = null;
    }
    string actionUrl = Url.Action("CreateUserRole", "ManageUser");
    if (Model.RoleID > 0)
        actionUrl = Url.Action("UpdateUserRole", "ManageUser", new RouteValueDictionary { { "roleID", Model.RoleID } });
%>
<form id="editUserRoleForm" name="editUserRoleForm" action="<%=actionUrl %>" method="post"
class="tn-helper-reset nyroModal">
<div class="tn-form-box">
    <div class="tn-text-heading tn-border-gray tn-border-bottom">
        <h4>编辑用户角色</h4></div>
    <table>
        <tr>
            <th>
                角色惟一英文名称：
            </th>
            <td>
            <span class="tn-form-row">
                <% if (Model.RoleID > 0) Response.Write(Model.RoleName);
                   else
                   { %>
                <input type="text" id="roleName" name="roleName" onkeyup="$('#fileName').html($('#roleName').attr('value'));"
                    class="tn-textbox tn-input-long tn-border-gray" value="<%=Model.RoleName %>" />
                <%} %>
                </span>
            </td>
        </tr>
        <% if (Model.RoleID > 0)
           { %>
        <tr>
            <th>
                角色标识图片：
            </th>
            <td>
            <span class="tn-form-row">
                <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/RoleIcons/" + Model.RoleName.ToLower() + ".gif")%>"
                    title="<%=Model.FriendlyRoleName %>" alt="<%=Model.RoleName %>" />
                    </span>
            </td>
        </tr>
        <%} %>
        <tr>
            <th>
                角色标识图片位置：
            </th>
            <td>
            <span class="tn-form-row">
                Web\Themes\Shared\Styles\RoleIcons\<span id="fileName"><%=Model.RoleName.ToLower() %></span>.gif
                </span>
            </td>
        </tr>
        <tr>
            <th>
                &nbsp;
            </th>
            <td>
                <span class="tn-form-row">请确保该文件存在，该角色的会员将会用该标识图片突出显示</span>
            </td>
        </tr>
        <tr>
            <th>
                角色对外显示名称：
            </th>
            <td>
            <span class="tn-form-row">
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="friendlyRoleName"
                    name="friendlyRoleName" value="<%=Model.FriendlyRoleName %>" />
                    </span>
            </td>
        </tr>
        <tr>
            <th>
                <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %>
            </th>
            <td>
                <span class="tn-form-row">
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="description"
                    name="description" value="<%=Model.Description %>" />
                    </span>
            </td>
        </tr>
        <tr>
            <th>
                <%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %>
            </th>
            <td>
            <span class="tn-form-row">
                <input id="enabled-true" class="tn-radiobutton" name="enabled" type="radio" <% if(Model.Enabled) Response.Write("checked=\"checked\""); %>
                    value="true" /><label for="enabled-true">启用</label>
                <input id="enabled-false" class="tn-radiobutton" name="enabled" type="radio" <% if(!Model.Enabled) Response.Write("checked=\"checked\""); %>
                    value="false" /><label for="enabled-false">不启用</label>
                    </span>
            </td>
        </tr>
        <tr>
            <th>
                是否对外展示：
            </th>
            <td>
                <span class="tn-form-row">
                <input id="isPublic-true" class="tn-radiobutton" name="isPublic" type="radio" <% if(Model.IsPublic) Response.Write("checked=\"checked\""); %>
                    value="true" /><label for="isPublic-true"><%=GetResourceString("Label_Display")%></label>
                <input id="isPublic-false" class="tn-radiobutton" name="isPublic" type="radio" <% if(!Model.IsPublic) Response.Write("checked=\"checked\""); %>
                    value="false" /><label for="isPublic-false">不显示</label>
                    </span>
            </td>
        </tr>
        <tr>
            <th>
            </th>
            <td>
                <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default,null, null)%>
                <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
            </td>
        </tr>
    </table>
</div>
</form>
<script type="text/javascript">
    $(document).ready(function() {
        $("#editUserRoleForm").validate({
            rules: {
                roleName: { required: true, maxBlength: 16 },
                friendlyRoleName: { required: true, maxBlength: 16 },
                description: { maxBlength: 16 }
            },
            messages: {
                roleName: { required: "请填写角色名称", maxBlength: "角色名称的最大长度不能超过16字" },
                friendlyRoleName: { required: "请填写角色对外显示名称", maxBlength: "角色对外显示名称的最大长度不能超过16字" },
                description: { maxBlength: "角色描述的最大长度不能超过16字" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#editUserRoleForm").valid()) {
                return false;
            }
        });
    });
</script>
