﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        //StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //  关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        //else if (messageType == StatusMessageType.Error)
        //{
        //    Response.Write(TempData.GetString("StatusMessageContent", string.Empty));
        //}
        TempData["StatusMessageType"] = null;
    }

    if (ViewData["User"] != null)
    {
        User u = ViewData["User"] as User;
        if (u != null)
        {      
%>
<form action="<%=Url.Action("Control_UpdatePassword", "ManageUser", new { UserID = u.UserID })%>"
method="post" class="tn-helper-reset nyroModal" id="PWForm">
<div class="tn-form-box">
    <div class="tn-text-heading tn-border-gray tn-border-bottom">
        <h4>
            修改用户密码</h4>
    </div>
    <div class="description">
        请保持两次输入的密码一致。</div>
    <table>
        <tr>
            <th>
                用户名：
            </th>
            <td>
                <span class="tn-form-row">
            <%=u.UserName%>
            </span>
            </td>
        </tr>
        <tr>
            <th>
                新密码：
            </th>
            <td>
                <span class="tn-form-row">
            <input name="pw1" id="pw1" type="password" class="tn-textbox tn-input-long tn-border-gray" />
            </span>
            </td>
        </tr>
        <tr>
            <th>
                重复新密码：
            </th>
            <td>
                <span class="tn-form-row">
            <input name="pw2" id="pw2" type="password" class="tn-textbox tn-input-long tn-border-gray" />
            </span>
            </td>
        </tr>
        <tr>
            <td>
            </td>
            <td>
                <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default,null, null)%>
                <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
            </td>
        </tr>
    </table>
    <%
        }
    }
    %>
</div>

<script type="text/javascript" rel="forceLoad">
    <!--
        $(document).ready(function() {
            $("#PWForm").validate({
                rules: { 
                pw1: { required: true, maxlength: 64 },
                pw2: { required: true, maxlength: 64, equalTo: "#pw1"},
                  },
                messages: {    
                 pw1: { required: "请输入新密码", maxlength: "最大长度不能超过64" },
                 pw2: { required: "请输入重复新密码", maxlength: "最大长度不能超过64",equalTo:"两次密码不相同" },
                  }
            });

            $("#saveButton").click(function() {
                if (!$("#PWForm").valid()) {
                    return false;
                }
            });
        }); 
   //--> 
</script>

</form>
