﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<SiteCategory>>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
        }
        else if (messageType == StatusMessageType.Error)
        {
            Response.Write(TempData.GetString("StatusMessageContent", string.Empty));
        }
        TempData["StatusMessageType"] = null;
    }

    if (ViewData["fromCategory"] != null)
    {
        bool isMerge = ViewData.GetBool("isMerge", true);
        SiteCategory fromCategory = ViewData["fromCategory"] as SiteCategory;
        int applicationID = Request.QueryString.GetInt("applicationID", 0);
        int depth = Request.QueryString.GetInt("depth", 1);
%>
<form id="MergeOrMoveCategoryForm" action="<%=this.Url.Action("MergeOrMoveCategory", "Manage", new {applicationID = applicationID, depth=depth,isMerge=isMerge,fromCategoryID=fromCategory.CategoryID })%>"
method="post" class="tn-helper-reset nyroModal">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <% if (isMerge)
           { %>
        移到当前类别下的子类及内容到目标类别下，删除该类别
        <%}
           else
           { %>
        将当前类别移动到目标类别下，作为目标类别的子类别
        <%} %>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            当前类别：</label>
        <% if (fromCategory != null) Response.Write(fromCategory.CategoryName); %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            目标类别：</label>
        <select name="toCategoryID" id="toCategoryID" class="tn-dropDownList">
            <option selected="selected" value="">--请 选 择-- </option>
            <%foreach (var toCategory in ViewData.Model as List<SiteCategory>)
              {%>
            <option value="<%=toCategory.CategoryID %>">
                <%for (int i = 0; i < toCategory.Depth; i++) { Response.Write("&nbsp;&nbsp;"); } %>
                <%=toCategory.CategoryName%></option>
            <%}%>
        </select>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input type="submit" value="<%=GetResourceString("Button_Save") %>" id="SaveButton" />
        <input type="button" value="<%=GetResourceString("Button_Cancel") %>" class="nyroModalClose" />
    </div>
</div>
</form>
<%} %>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#MergeOrMoveCategoryForm").validate({
            rules: {
                toCategoryID: "required"
            },
            messages: {
                toCategoryID: "请选择目标类别"
            }
        });

        $("#SaveButton").click(function() {
            if (!$("#MergeOrMoveCategoryForm").valid()) {
                return false;
            }
        });
    }); 
</script>

