﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<NewsSection>>" %>
<%
    if (ViewData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)ViewData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, ViewData.GetString("StatusMessageContent", string.Empty)));

        //关闭模式窗口
        if (messageType != StatusMessageType.Hint)
        {
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        ViewData["StatusMessageType"] = null;

    }
%>
<%
    if (ViewData.Model != null && (StatusMessageType)ViewData.GetInt("StatusMessageType", (int)StatusMessageType.Error) != StatusMessageType.Success)
    {  %>
<form id="modalForm" method="post" action="<%=Url.Action("Control_UpdateNewsSection", "ManageNews", new { selectedThreadIDsString = ViewData["ListThreadID"] as string })%>"
class="tn-helper-reset nyroModal">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        设置栏目</h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
                    请选择栏目：</label>
        <select name="toCategoryID" id="toCategoryID" class="tn-dropdownlist">
            <option selected="selected" value="">--请 选 择-- </option>
            <%foreach (var toSection in ViewData.Model as List<NewsSection>)
              {%>
            <option value="<%=toSection.SectionID%>">
                <%for (int i = 0; i < toSection.Depth; i++) { Response.Write(" &nbsp; &nbsp;"); } %>
                <%=toSection.SectionName%></option>
            <%}%>
        </select>
        <span class="tn-form-required">(必填)</span>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label"> </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_OK"), ButtonSizes.Large, null, null)%>
        <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
    </div>
</div>
</form>

<script type="text/javascript" rel="forceLoad">
    <!--
    $(document).ready(function() {
        $("#modalForm").validate({
            rules: {
                toCategoryID: { required: true }
            },
            messages: {
                toCategoryID: { required: "请选择类别" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#modalForm").valid()) {
                return false;
            }
        });
    }); 
   //--> 
</script>

<%
    }%>