﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<NewsSection>" %>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
        }
        else
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        }
        TempData["StatusMessageType"] = null;
    }
    Dictionary<string, Language> languages = Languages.GetLanguages(false);
    NewsSection section = ViewData.Model; %>

<form id="editor" action="<%=this.Url.Action("CreateUpdateSection", "ManageNews", new { sectionID=section.SectionID,parentID=section.ParentID })%>"
method="post" class="nyroModal">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
      <%if (section.SectionID > 0) Response.Write("编辑"); else { Response.Write("添加子栏目"); } %>
    </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> 栏目名称：</label>
      <input type="text" class="tn-textbox tn-input-long tn-border-gray" maxlength="256"
            id="title" name="title" value="<%=section.SectionName %>" />
      <span> <%=GetResourceString("Description_Required")%></span> </div>
    <% foreach (Language language in languages.Values)
       { %>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=language.NativeName%>名称： </label>
      <input name="sectionName_<%=language.LanguageCode %>" type="text" class="tn-textbox tn-input-long tn-border-gray"
            value="<% if (section.SectionNameRes != null && section.SectionNameRes.ContainsKey(language.LanguageCode)) Response.Write(section.SectionNameRes[language.LanguageCode]); %>" />
    </div>
    <%} %>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
      <textarea class="tn-textarea tn-input-long tn-border-gray" id="body" name="body"
            rows="6" cols="27"><%=section.Description %></textarea>
      <span style="display:none"></span>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 详细显示页面：</label>
      Pages\News\
      <input type="text" class="tn-textbox tn-input-medium  tn-border-gray"
            id="PageDetail" name="PageDetail" maxlength="56" value="<%=string.IsNullOrEmpty(section.PageDetail)?"ShowNews":section.PageDetail %>" />
      .aspx </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 栏目列表显示页面：</label>
      Pages\News\
      <input type="text" class="tn-textbox tn-input-medium  tn-border-gray"
            id="PageList" name="PageList" maxlength="56" value="<%=string.IsNullOrEmpty(section.PageList)?"ListNews":section.PageList %>" />
      .aspx </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 显示栏目首页：</label>
      Pages\News\
      <input type="text" class="tn-textbox tn-input-medium  tn-border-gray"
            id="PageShowSection" name="PageShowSection" maxlength="56" value="<%=string.IsNullOrEmpty(section.PageShowSection)?"ListNewsForChild":section.PageShowSection %>" />
      .aspx
      <div class="tn-text-note"> 如果没有子栏目，显示方式与列表页相同</div>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 排序序号：</label>
      <input type="text" class="tn-textbox tn-input-medium  tn-border-gray" id="sortNumber"
            name="sortNumber" maxlength="256" value="<%=section.DisplayOrder %>" />
      <span>(必填)</span> </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_OK"), ButtonSizes.Large, null, null)%> <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%> </div>
  </div>
</form>
<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#editor").validate({
            rules: {
                title: { required: true, maxBlength: 50 },
                body: { maxBlength: 300 },
                sortNumber: { required: true, digits: true }
            },
            messages: {
                title: { required: "请输入标题", maxBlength: "最多50字" },
                body: { maxBlength: "最多300字" },
                sortNumber: { required: "请输入排序序号", digits: "请输入非负整数" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#editor").valid()) {
                return false;
            }
        });
    }); 
</script>
