﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<NewsSection>>" %>
<% Dictionary<string, Language> languages = Languages.GetLanguages(false); %>
<table class="tn-table-grid">
    <tr class="tn-table-grid-header">
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            栏目名称
        </th>
        <% foreach (Language language in languages.Values)
           { %>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            <%=language.NativeName%>
        </th>
        <%} %>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            栏目描述
        </th>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            资讯总数
        </th>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            评论总数
        </th>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            操作
        </th>
    </tr>
    <%
        foreach (var section in ViewData.Model)
        {%>
    <tr class="tn-table-grid-row">
        <td class="tn-border-gray tn-border-bottom">
            <%for (int i = 0; i < section.Depth; i++) { Response.Write("&nbsp; &nbsp; &nbsp; &nbsp; "); } %>
            <a target="_blank" href="<%=this.Url.Action("ListNewsForChild", "ChannelNews", new { sectionID = section.SectionID })%>">
                <%=section.SectionName %></a>
        </td>
        <% foreach (string languageCode in languages.Keys)
           { %>
        <td class="tn-border-gray tn-border-bottom">
            <% if (section.SectionNameRes != null && section.SectionNameRes.ContainsKey(languageCode)) Response.Write(section.SectionNameRes[languageCode]); else Response.Write("未填"); %>
        </td>
        <%} %>
        <td class="tn-border-gray tn-border-bottom">
            <span title="<%=section.Description %>"> <%=StringUtils.Trim(section.Description,20) %></span>
        </td>
        <td class="tn-border-gray tn-border-bottom">
            <%=section.ThreadCount %>
        </td>
        <td class="tn-border-gray tn-border-bottom">
            <%=section.CommentCount %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
            <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                menu="#MenuButton_<%=section.SectionID %>"> <span class="tn-icon tn-icon-triangle-down"></span> <a href="<%=this.Url.Action("Control_EditSection", "ManageNews", new { sectionID = section.SectionID })%>"
                class="tn-action-text editSectionModal">编辑</a></span>
            <div id="MenuButton_<%=section.SectionID %>" class="tn-drop-menu ui-widget-content"
                style="display: none;">
                <ul class="tn-menu-drop-list">
                    <li class="tn-menu-drop-item"><a href="javascript:;"  onclick="if (confirm('点击确定将直接删除子栏目和资讯，需要保留子栏目和资讯请点击取消执行合并或移动操作,要删除吗？')) { $('#sectionForLoad').load('<%=this.Url.Action("DeleteSection","ManageNews",new { sectionID=section.SectionID}) %>' )}">
                        删除</a></li>
                    <%if (section.Depth < 3)
                      { %>
                    <li class="tn-menu-drop-item"><a class="submit editSectionModal" href="<%=this.Url.Action("Control_EditSection", "ManageNews", new { parentID =section.SectionID})%>">
                        添加子栏目</a></li>
                    <%} %>
                    <li class="tn-menu-drop-item"><a title="将该栏目下的所有子栏目和资讯<%=GetResourceString("Enum_AccountStatuses_All")%>移到目标栏目下，同时删除该栏目" class="submit editSectionModal"
                        href="<%=this.Url.Action("Control_MergeOrMoveSection", "ManageNews", new {isMerge=true, FilterID =section.SectionID})%>">
                        合并</a></li>
                    <li class="tn-menu-drop-item"><a title="将该栏目移动到目标栏目下，作为目标栏目的子栏目" class="submit editSectionModal"
                        href="<%=this.Url.Action("Control_MergeOrMoveSection", "ManageNews", new {isMerge=false, FilterID =section.SectionID})%>">
                        转移</a> </li>
                </ul>
            </div>
        </td>
    </tr>
    <%}%>
</table>

<script type="text/javascript">
    $(document).ready(function() {
        $('.editSectionModal').nyroModal({
            resizeable: true,
            endRemove: function(elts, settings) {
                $('#sectionForLoad').load('<%=this.Url.Action("Control_ListSections", "ManageNews")%>');
            }
        });
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
    });
</script>

