﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
        }
        else
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        }
        TempData["StatusMessageType"]=null;
    }   
%>
<%if (ViewData["fromSection"] != null)
  {
      bool isMerge = ViewData.GetBool("isMerge", true);
      NewsSection fromSection = ViewData["fromSection"] as NewsSection;%>
<form id="editor" action="<%=this.Url.Action("MergeOrMoveSection", "ManageNews", new {isMerge=isMerge,fromSectionID=fromSection.SectionID })%>"
method="post" class="tn-helper-reset nyroModal">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%if (isMerge) Response.Write("合并"); else { Response.Write("转移"); } %></h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
                    当前栏目：</label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" maxlength="256"
                id="title" name="title" disabled="disabled" value="<%=fromSection.SectionName %>" />
            <span>(必填)</span>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
                    目标栏目：</label>
            <select name="sectionDDL" id="sectionDDL" class="tn-dropdownlist">
                <option selected="selected" value="">--请 选 择-- </option>
                <%if (!isMerge)
                  { %><option value="0">根栏目</option>
                <%} %>
                <%foreach (var toSection in ViewData.Model as List<NewsSection>)
                  {%>
                <option value="<%=toSection.SectionID %>">
                    <%for (int i = 0; i < toSection.Depth; i++) { Response.Write("&nbsp;&nbsp;"); } %>
                    <%=toSection.SectionName%></option>
                <%}%>
            </select>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label"> </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_OK"), ButtonSizes.Large, null, null)%>
        <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
    </div>
</div>
</form>
<%} %>

<script type="text/javascript" rel="forceLoad">
    <!--
    $(document).ready(function() {
        $("#editor").validate({
            rules: {
                sectionDDL: "required"
            },
            messages: {
                sectionDDL: "请选择栏目"
            }
        });

        $("#saveButton").click(function() {
            if (!$("#editor").valid()) {
                return false;
            }
        });
    }); 
   //--> 
</script>

