﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoComment>>" %>
<table class="tn-table-grid">
    <tbody>
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-width-check">
                        <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_Body")%>
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    评论图片
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_CommentUser")%>
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_CommentDate") %>
                </th>
            </tr>
            <%
                if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
                {
                    PagingDataSet<PhotoComment> PgCommentDataSet = ViewData.Model as PagingDataSet<PhotoComment>;
                    IList<PhotoComment> CommentLists = PgCommentDataSet.Records;
                    foreach (var item in CommentLists)
                    {
                        string commentedUserName = UserID2UserNameDictionary.GetUserName(item.OwnerUserID);
            %>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" class="tn-checkbox" name="CheckBoxGroup" value="<%=item.PostID %>:<%=item.OwnerUserID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                    <a target="_blank" href="<%=string.Format("{0}#{1}", Url.Action("ShowPhoto", "Photo", new { userDomainName=commentedUserName,threadID=item.ThreadID }),item.PostID)%>" title="<%=HtmlUtils.StripForPreview(item.Body)%>">
                        <%=HtmlUtils.TrimHtml(item.Body,50) %></a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-pic">
                    <%=SPBHtmlHelper.Instance().ShowPicture(item.ThreadID, PhotoImageType.Icon) %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                    <%if (item.UserID > 0)
                      { %>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                        <%=item.Author%></a>
                    <%
                        }
                      else
                      {
                          Response.Write(item.Author);
                      }
                    %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <%=Formatter.FormatDate(item.PostDate) %>
                </td>
            </tr>
            <% }
                }%>
        </tbody>
</table>
<div class="tn-pagination tn-helper-align-center">
    <%--<% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgCommentDataSet.TotalRecords, PgCommentDataSet.PageSize, PgCommentDataSet.PageIndex, 11, Url.Action("ListManageComments", "ManageFile", new { status = (AuditingStatusesForDisplay)(CommentLists[0].AuditingStatus), pageIndex = "{0}" })));   %>--%>
    <% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, null));   %>
</div>
