﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (ViewData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)ViewData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, ViewData.GetString("StatusMessageContent", string.Empty)));

        //关闭模式窗口
        if (messageType != StatusMessageType.Hint)
        {
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        ViewData["StatusMessageType"] = null;

    }
%>
<%
    if (ViewData.Model != null && (StatusMessageType)ViewData.GetInt("StatusMessageType", (int)StatusMessageType.Error) != StatusMessageType.Success)
    {
%>
<form id="modalForm" class="nyroModal" method="post" action="<%=Url.Action("Control_UpdateSiteCategories", "ManagePhoto", new { selectedThreadIDsString = ViewData["ListThreadID"] as string })%>">
<div class="tn-form tn-label-right">
<h4 class="tn-text-heading tn-border-gray tn-border-bottom">
    设置站点类别</h4>
    <div class="tn-form-row">
    <label class="tn-form-label">请选择站点类别：</label>
    <select name="toCategoryID" id="toCategoryID" class="tn-dropdownlist">
                <option selected="selected" value="">--请 选 择-- </option>
                <%foreach (var toCategory in ViewData.Model as List<SiteCategory>)
                  {%>
                <option value="<%=toCategory.CategoryID %>">
                    <%for (int i = 0; i < toCategory.Depth; i++) { Response.Write("&nbsp;&nbsp;"); } %>
                    <%=toCategory.CategoryName%></option>
                <%}%>
            </select>
    </div>
    <div class="tn-form-row tn-form-row-button">
    <label class="tn-form-label"></label>
   <%-- <%=SPBHtmlHelper.Instance().SubmitButton("saveButton","确定", ButtonSizes.Large, null, null)%>
        <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>--%>
     <input type="submit" value="<%=GetResourceString("Button_Save") %>" id="SaveButton" class="saveButton" />
    <input type="reset" value="<%=GetResourceString("Button_Cancel") %>" class="nyroModalClose" />
    </div>

</div>
</form>

<script type="text/javascript" rel="forceLoad">
    <!--
    $(document).ready(function() {
        $("#modalForm").validate({
            rules: {
                toCategoryID: { required: true }
            },
            messages: {
                toCategoryID: { required: "请选择类别" }
            }
        });

        $("#SaveButton").click(function() {
            if (!$("#modalForm").valid()) {
                return false;
            }
        });
    }); 
   //--> 
</script>

<%
    }
%>