﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%   
    if (TempData["StatusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        TempData["StatusMessageData"] = null;
    }
%>
<form id="DeleteUserExpiredDataForm" name="DeleteUserExpiredDataForm" class="nyroModal tn-helper-reset"
action="<%=Url.Action("ExecDeleteSiteExpiredData","ManageSettings") %>" method="post">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        清除过期数据
    </h4>
    <p class="tn-text-note">
        <strong>可以清除的过期数据类型有：</strong>
    </p>
    <p class="tn-text-note">
        a) 用户的访客记录； b) 个人动态；c) 朋友动态；d) 用户积分记录；e) 私信；f) 用户留言；g) 群组留言；
    </p>
    <br />
    <p class="tn-text-note">
        请选择数据类型和日期，系统将会根据所选日期，清除相应数据类型的过期数据
    </p>
    <br />
    <div class="tn-form-row">
        <label class="tn-form-label">
            数据类型：
        </label>
        <select id="siteExpiredDataType" name="siteExpiredDataType" class="tn-dropdownlist">
        
            <option value="1">用户访客记录</option>
            <option value="2">用户个人动态</option>
            <option value="3">用户朋友动态</option>
            <option value="4">用户私信</option>
            <option value="5">用户积分记录</option>
            <option value="6">用户留言</option>
            <option value="7">群组留言</option>
        </select>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_Date") %><%=GetResourceString("Common_Colon") %>
        </label>
        <select id="beforeDays" name="beforeDays" class="tn-dropdownlist">
            <option value="30">1个月之前</option>
            <option value="60">2个月之前</option>
            <option value="120">4个月之前</option>
            <option value="180">6个月之前</option>
            <option value="150">9个月之前</option>
            <option value="365">1年之前</option>
            <option value="540">1.5年之前</option>
            <option value="720">2年之前</option>
        </select>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input type="submit" value="<%=GetResourceString("Button_OK")%>" />
        <input type="button" class="nyroModalClose" value="<%=GetResourceString("Button_Close")%>" />
    </div>
</div>
</form>
<%   
    int typeValue = TempData.GetInt("siteExpiredDataType", 1);
    int beforeDays = TempData.GetInt("beforeDays", 30);
%>

<script type="text/javascript">
    $(document).ready(function() {
        $("#siteExpiredDataType").val("<%=typeValue %>");
        $("#beforeDays").val("<%=beforeDays %>");
    }); 
</script>

