﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Area>" %>

<div class="spb-area-edit">
  <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            if (messageType == StatusMessageType.Success)
            {
                //关闭模式窗口
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["StatusMessageType"] = null;
        }
        string actionUrl = Url.Action("CreateArea", "ManageSettings");
        if (!string.IsNullOrEmpty(Model.AreaCode))
            actionUrl = Url.Action("UpdateArea", "ManageSettings", new RouteValueDictionary { { "areaCode", Model.AreaCode } });
        Dictionary<string, Language> languages = Languages.GetLanguages(false); 
    %>
  <form method="post" action="<%=actionUrl %>" class="nyroModal" name="AreaForm"
    id="AreaForm">
    <div class="tn-form tn-label-right">
      <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <% if (string.IsNullOrEmpty(Model.AreaCode)) Response.Write("添加地区"); else Response.Write("编辑地区"); %>
      </h4>
      <% if (Model.Parent != null)
           {
        %>
      <div class="tn-form-row">
        <label class="tn-form-label"> 父级地区名称： </label>
        <%=Model.Parent.Name %> </div>
      <%} %>
      <div class="tn-form-row">
        <label class="tn-form-label"> 行政区号： </label>
        <% if (string.IsNullOrEmpty(Model.AreaCode) || TempData.GetBool("isWritten", false))
                   { %>
        <input name="areaCode" type="text" class="tn-textbox tn-input-long tn-border-gray" value="" />
        <span class="tn-form-required">(必填)</span>
        <div class="tn-text-note"> 请认真阅读区号编码规范，一旦填写将不允许修改</div>
        <%}
                   else Response.Write(Model.AreaCode); %>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> 地区名称： </label>
        <input name="areaName" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=Model.Name %>" />
        <span class="tn-form-required">(必填)</span> </div>
      <% foreach (Language language in languages.Values)
           { %>
      <div class="tn-form-row">
        <label class="tn-form-label"> <%=language.NativeName%>名称： </label>
        <input name="areaName_<%=language.LanguageCode %>" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%if (Model.AreaNameResForAdmin != null && Model.AreaNameResForAdmin.ContainsKey(language.LanguageCode)) Response.Write(Model.AreaNameResForAdmin[language.LanguageCode]); %>" />
      </div>
      <%} %>
      <div class="tn-form-row">
        <label class="tn-form-label"> 父级地区： </label>
        <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("parentCode", string.Empty, Model.ParentCode, 3, "tn-dropdownlist"));%>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> 排序序号： </label>
        <input name="displayOrder" class="tn-textbox tn-input-long tn-border-gray" type="text" value="<%=Model.DisplayOrder %>" />
        <span class="tn-form-required">(必填)</span> </div>
      <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label"> </label>
        <input id="saveButton"  type="submit" value="<%=GetResourceString("Button_Submit")%>" />
        &nbsp; &nbsp;
        <input id="cancelButton"  type="button" value="<%=GetResourceString("Button_Cancel")%>"
                    onclick="$.nyroModalRemove();return false;" />
      </div>
    </div>
  </form>
</div>
<script type="text/javascript" rel="forceLoad">
        $(document).ready(function() {
            $("#AreaForm").validate({
                rules: {
                areaCode:{required: true,rangelength:[8,8]},
                    name: { required: true },
                    displayOrder: { required: true, digits:true },
                },
                messages: {
                    areaCode:{required: "请填写地区行政区号",rangelength:"行政区号必须是八位"},
                    name: { required: "请填写地区名称"},
                    displayOrder: { required: "请填写排序序号", digits:"请输入非负整数"},
                }
            });

            $("#saveButton").click(function() {
                if (!$("#AreaForm").valid()) {
                    return false;
                }
            });
        }); 
</script>
