﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));

        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }

    CodeItem item = null;
    if (ViewData["item"] != null)
        item = ViewData["item"] as CodeItem;
    string action=string.Empty;
        if (item != null)
        action = SPBUrlHelper.Action("UpdateCodeItem", "ManageSettings", new RouteValueDictionary { { "codeSetCode", item.CodeSetCode }, { "itemID", item.ItemID } });
    else
            action = SPBUrlHelper.Action("CreateCodeItem", "ManageSettings", new RouteValueDictionary { { "codeSetCode", ViewData["codeSetCode"].ToString() } });

%>
<form action="<%=action%>" method="post" id="editorForm" class="nyroModal tn-helper-reset">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        添加/修改代码项
    </h4>
          <div class="tn-form-row">
        <label class="tn-form-label">
            代码项ID：</label>
            <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px;" name="ItemID" <%if (item!=null) Response.Write("readonly=\"readonly\""); %>
                        value="<%if(item!=null) Response.Write(item.ItemID); %>" <span class="tn-form-required">(必填，设置后不可更改)</span>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            代码项名称：</label>
        <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 200px;" name="ItemName" value="<%if(item!=null) Response.Write(item.Name); %>" /><span
                class="tn-form-required">(必填)</span>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            排序依据：</label>
        <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 200px;" name="ItemDisplayOrder" value="<%if(item!=null) Response.Write(item.DisplayOrder); %>" /><span
                class="tn-form-required">(必填)</span>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input id="editorFormsaveButton" type="submit" value="提交" />
        &nbsp;
        <input type="button" onclick="$.nyroModalRemove();" value="取消" />
    </div>
</div>
</form>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#editorForm").validate({
            rules: {
                ItemID: { required: true, digits: true },
                ItemName: { required: true, maxBlength: 10 },
                ItemDisplayOrder: { required: true, digits: true }
            },
            messages: {
                ItemID: { required: "请输入代码项ID", digits: "请输入非负整数" },
                ItemName: { required: "请输入代码项名称", maxBlength: "不能超过100个字符" },
                ItemDisplayOrder: { required: "请输入排序序号", digits: "请输入非负整数" }
            }
        });

        $("#editorFormsaveButton").click(function() {
            if (!$("#editorForm").valid()) {
                return false;
            }
        });
    }); 
</script>

